/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DistributionPoint;

public class CRLDistPoint
implements DEREncodable {
    ASN1Sequence seq = null;

    public CRLDistPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public CRLDistPoint(DistributionPoint[] distributionPointArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int n = 0;
        while (n != distributionPointArray.length) {
            aSN1EncodableVector.add(distributionPointArray[n]);
            ++n;
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public DERObject getDERObject() {
        return this.seq;
    }

    public static CRLDistPoint getInstance(Object object) {
        if (object instanceof CRLDistPoint) {
            return (CRLDistPoint)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CRLDistPoint((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public static CRLDistPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }
}

