/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable algorithms = new Hashtable();

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("RSAWITHMD5", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RSAWITHSHA1", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
    }

    public PKCS10CertificationRequest(String string, X509Name x509Name, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(string, x509Name, publicKey, aSN1Set, privateKey, "BC");
    }

    public PKCS10CertificationRequest(String string, X509Name x509Name, PublicKey publicKey, ASN1Set aSN1Set, PrivateKey privateKey, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)algorithms.get(string.toUpperCase());
        if (dERObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        if (x509Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = new AlgorithmIdentifier(dERObjectIdentifier, null);
        byte[] byArray = publicKey.getEncoded();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        try {
            this.reqInfo = new CertificationRequestInfo(x509Name, new SubjectPublicKeyInfo((ASN1Sequence)dERInputStream.readObject()), aSN1Set);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature signature = Signature.getInstance(this.sigAlgId.getObjectId().getId(), string2);
        signature.initSign(privateKey);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(this.reqInfo);
            signature.update(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new SecurityException("exception encoding TBS cert request - " + exception);
        }
        this.sigBits = new DERBitString(signature.sign());
    }

    public PKCS10CertificationRequest(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence);
    }

    public PKCS10CertificationRequest(byte[] byArray) {
        super(PKCS10CertificationRequest.toDERSequence(byArray));
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        return this.getPublicKey("BC");
    }

    public PublicKey getPublicKey(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.reqInfo.getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(new DERBitString(subjectPublicKeyInfo).getBytes());
            AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithmId();
            return KeyFactory.getInstance(algorithmIdentifier.getObjectId().getId(), string).generatePublic(x509EncodedKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("error encoding public key");
        }
    }

    private static ASN1Sequence toDERSequence(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            return (ASN1Sequence)dERInputStream.readObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify("BC");
    }

    public boolean verify(String string) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(this.sigAlgId.getObjectId().getId(), string);
        signature.initVerify(this.getPublicKey(string));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(this.reqInfo);
            signature.update(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new SecurityException("exception encoding TBS cert request - " + exception);
        }
        return signature.verify(this.sigBits.getBytes());
    }
}

