@echo off
rem 
rem build script for 1.2
rem

set DEVEL_ROOT=g:\devel\crypto
set SRC_ROOT=%DEVEL_ROOT%\src
set OUTPUT_CLASSES=%DEVEL_ROOT%\classes

set DR=%DEVEL_ROOT%
set SR=%SRC_ROOT%
set OC=%OUTPUT_CLASSES%

goto NODEL
cd %OC%
deltree /y *
:NODEL

:UTIL
echo Util
cd %SR%\org\bouncycastle\util\
javac -d %OC% -classpath %OC% encoders\*.java test\*.java

:MATH
echo Math
cd %SR%\org\bouncycastle\math\ec\
javac -d %OC% -classpath %OC% *.java

:ASN1
echo ASN1
cd %SR%\org\bouncycastle\asn1\
javac -d %OC% -classpath %OC% *.java pkcs\*.java test\*.java util\*.java x509\*.java

:CRYPTO
echo Crypto
cd %SR%\org\bouncycastle\crypto
javac -d %OC% -classpath %OC% *.java signers\*.java agreement\*.java digests\*.java encodings\*.java engines\*.java generators\*.java io\*.java macs\*.java modes\*.java params\*.java test\*.java

:JAVAXCRYPTO
echo Javax\Crypto
cd %SR%\javax\crypto
javac -d %OC% -classpath %OC% *.java interfaces\*.java spec\*.java

:PROVIDER
echo JCE\provider
cd %SR%\org\bouncycastle\jce\
javac -d %OC% -classpath %OC% *.java interfaces\*.java spec\*.java provider\*.java provider\test\*.java

rem goto NOTEST
echo "lighweight regression test"
java -classpath %OC% org.bouncycastle.crypto.test.RegressionTest
echo "provider regression test"
java -classpath %OC% org.bouncycastle.jce.provider.test.RegressionTest
:NOTEST

:END
cd %SR%
cd ..
