package org.bouncycastle.cms;

import java.security.cert.X509CertSelector;

/**
 * a basic index for a signer.
 */
public class SignerId
    extends X509CertSelector
{
    public int hashCode()
    {
        int     code = 0;

        if (this.getSerialNumber() != null)
        {
            code ^= this.getSerialNumber().hashCode();
        }

        if (this.getIssuerAsString() != null)
        {
            code ^= this.getIssuerAsString().hashCode();
        }

        return code;
    }

    public boolean equals(
        Object  o)
    {
        if (!(o instanceof SignerId))
        {
            return false;
        }

        SignerId id = (SignerId)o;

        if (id.getSerialNumber() != null)
        {
            if (!id.getSerialNumber().equals(this.getSerialNumber()))
            {
                return false;
            }
        }

        if (id.getIssuerAsString() != null)
        {
            if (!id.getIssuerAsString().equals(this.getIssuerAsString()))
            {
                return false;
            }
        }

        return true;
    }
}
