/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class DigestTest
implements Test {
    static final String provider = "BC";

    public String getName() {
        return "Digest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        DigestTest digestTest = new DigestTest();
        TestResult testResult = digestTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        boolean bl = false;
        TestResult testResult = this.test("SHA-1");
        if (!testResult.isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-256")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-384")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("SHA-512")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD2")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD4")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("MD5")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD128")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("RIPEMD160")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (!(testResult = this.test("Tiger")).isSuccessful()) {
            System.out.println(testResult);
            bl = true;
        }
        if (bl) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": Failed");
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    TestResult test(String string) {
        byte[] byArray = "hello world".getBytes();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, provider);
            byte[] byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = messageDigest.digest(byArray);
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 1 not equal");
            }
            int n = 0;
            while (n < byArray.length) {
                messageDigest.update(byArray[n]);
                ++n;
            }
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 2 not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 3 not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            MessageDigest messageDigest2 = (MessageDigest)messageDigest.clone();
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 4(a) not equal");
            }
            messageDigest2.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest2.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 4(b) not equal");
            }
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.reset();
            messageDigest.update(byArray, 0, byArray.length / 2);
            messageDigest.update(byArray, byArray.length / 2, byArray.length - byArray.length / 2);
            byArray3 = messageDigest.digest();
            if (!MessageDigest.isEqual(byArray2, byArray3)) {
                return new SimpleTestResult(false, "Result object 5 not equal");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed excpetion - " + exception.toString());
        }
    }
}

