/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SigTest
implements Test {
    public String getName() {
        return "SigTest";
    }

    private boolean isEqualTo(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SigTest sigTest = new SigTest();
        TestResult testResult = sigTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        try {
            Signature signature = Signature.getInstance("SHA1WithRSAEncryption", "BC");
            byte[] byArray = new byte[10];
            byArray[0] = 1;
            byArray[1] = 2;
            byArray[2] = 3;
            byArray[3] = 4;
            byArray[4] = 5;
            byArray[5] = 6;
            byArray[6] = 7;
            byArray[7] = 8;
            byArray[8] = 9;
            byte[] byArray2 = byArray;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(512, new SecureRandom());
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            signature.initSign(privateKey);
            signature.update(byArray2);
            byte[] byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "SHA1 verification failed");
            }
            signature = Signature.getInstance("MD2WithRSAEncryption", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "MD2 verification failed");
            }
            signature = Signature.getInstance("MD5WithRSAEncryption", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "MD5 verification failed");
            }
            signature = Signature.getInstance("RIPEMD160WithRSAEncryption", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "RIPEMD160 verification failed");
            }
            signature = Signature.getInstance("MD5WithRSA/ISO9796-2", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "MD5/ISO verification failed");
            }
            signature = Signature.getInstance("SHA1WithRSA/ISO9796-2", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "SHA1/ISO verification failed");
            }
            signature = Signature.getInstance("RIPEMD160WithRSA/ISO9796-2", "BC");
            signature.initSign(privateKey);
            signature.update(byArray2);
            byArray3 = signature.sign();
            signature.initVerify(publicKey);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "RIPEMD160/ISO verification failed");
            }
            BigInteger bigInteger = new BigInteger("ffffffff78f6c55506c59785e871211ee120b0b5dd644aa796d82413a47b24573f1be5745b5cd9950f6b389b52350d4e01e90009669a8720bf265a2865994190a661dea3c7828e2e7ca1b19651adc2d5", 16);
            BigInteger bigInteger2 = new BigInteger("03", 16);
            BigInteger bigInteger3 = new BigInteger("2aaaaaaa942920e38120ee965168302fd0301d73a4e60c7143ceb0adf0bf30b9352f50e8b9e4ceedd65343b2179005b2f099915e4b0c37e41314bb0821ad8330d23cba7f589e0f129b04c46b67dfce9d", 16);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privateKey2 = keyFactory.generatePrivate(new RSAPrivateKeySpec(bigInteger, bigInteger3));
            PublicKey publicKey2 = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
            byte[] byArray4 = Hex.decode((String)"5cf9a01854dbacaec83aae8efc563d74538192e95466babacd361d7c86000fe42dcb4581e48e4feb862d04698da9203b1803b262105104d510b365ee9c660857ba1c001aa57abfd1c8de92e47c275cae");
            byArray2 = Hex.decode((String)"fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210");
            signature = Signature.getInstance("RIPEMD160WithRSA/ISO9796-2", "BC");
            signature.initSign(privateKey2);
            signature.update(byArray2);
            byArray3 = signature.sign();
            if (!this.isEqualTo(byArray4, byArray3)) {
                return new SimpleTestResult(false, "SigTest: failed ISO9796-2 generation Test");
            }
            signature.initVerify(publicKey2);
            signature.update(byArray2);
            if (!signature.verify(byArray3)) {
                return new SimpleTestResult(false, "RIPEMD160/ISO verification failed");
            }
            return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
    }
}

