/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash = new byte[]{-38, 57, -93, -18, 94, 107, 75, 13, 50, 85, -65, -17, -107, 96, 24, -112, -81, -40, 7, 9};
    private SHA1Digest hash = new SHA1Digest();
    private byte[] encodingParams = null;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
    }

    private void ItoOSP(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
    }

    public byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        int n3;
        byte[] byArray2 = this.engine.processBlock(byArray, n, n2);
        byte[] byArray3 = null;
        if (byArray2.length < this.engine.getOutputBlockSize()) {
            byArray3 = new byte[this.engine.getOutputBlockSize()];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        } else {
            byArray3 = byArray2;
        }
        if (byArray3.length < 2 * this.defHash.length + 1) {
            throw new InvalidCipherTextException("data too short");
        }
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, this.defHash.length, byArray3.length - this.defHash.length, this.defHash.length);
        int n4 = 0;
        while (n4 != this.defHash.length) {
            int n5 = n4;
            byArray3[n5] = (byte)(byArray3[n5] ^ byArray4[n4]);
            ++n4;
        }
        byArray4 = this.maskGeneratorFunction1(byArray3, 0, this.defHash.length, byArray3.length - this.defHash.length);
        int n6 = this.defHash.length;
        while (n6 != byArray3.length) {
            int n7 = n6;
            byArray3[n7] = (byte)(byArray3[n7] ^ byArray4[n6 - this.defHash.length]);
            ++n6;
        }
        if (this.encodingParams == null) {
            n3 = 0;
            while (n3 != this.defHash.length) {
                if (this.defHash[n3] != byArray3[this.defHash.length + n3]) {
                    throw new InvalidCipherTextException("data hash wrong");
                }
                ++n3;
            }
        } else {
            throw new RuntimeException("forget something?");
        }
        n3 = 2 * this.defHash.length;
        while (n3 != byArray3.length) {
            if (byArray3[n3] == 1 || byArray3[n3] != 0) break;
            ++n3;
        }
        if (n3 >= byArray3.length - 1 || byArray3[n3] != 1) {
            throw new InvalidCipherTextException("data start wrong " + n3);
        }
        byte[] byArray5 = new byte[byArray3.length - ++n3];
        System.arraycopy(byArray3, n3, byArray5, 0, byArray5.length);
        return byArray5;
    }

    public byte[] encodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(byArray, n, byArray2, byArray2.length - n2, n2);
        byArray2[byArray2.length - n2 - 1] = 1;
        if (this.encodingParams != null) {
            throw new RuntimeException("forget something?");
        }
        System.arraycopy(this.defHash, 0, byArray2, this.defHash.length, this.defHash.length);
        byte[] byArray3 = new byte[this.defHash.length];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2.length - this.defHash.length);
        int n3 = this.defHash.length;
        while (n3 != byArray2.length) {
            int n4 = n3;
            byArray2[n4] = (byte)(byArray2[n4] ^ byArray4[n3 - this.defHash.length]);
            ++n3;
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.defHash.length);
        byArray4 = this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, this.defHash.length);
        int n5 = 0;
        while (n5 != this.defHash.length) {
            int n6 = n5;
            byArray2[n6] = (byte)(byArray2[n6] ^ byArray4[n5]);
            ++n5;
        }
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 1 - 2 * this.defHash.length;
        }
        return n;
    }

    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 1 - 2 * this.defHash.length;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.random = new SecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        this.engine.init(bl, asymmetricKeyParameter);
        this.forEncryption = bl;
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[this.defHash.length];
        byte[] byArray4 = new byte[4];
        int n4 = 0;
        this.hash.reset();
        do {
            this.ItoOSP(n4, byArray4);
            this.hash.update(byArray, n, n2);
            this.hash.update(byArray4, 0, byArray4.length);
            this.hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.defHash.length, this.defHash.length);
        } while (++n4 < n3 / this.defHash.length);
        if (n4 * this.defHash.length < n3) {
            this.ItoOSP(n4, byArray4);
            this.hash.update(byArray, n, n2);
            this.hash.update(byArray4, 0, byArray4.length);
            this.hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n4 * this.defHash.length, byArray2.length - n4 * this.defHash.length);
        }
        return byArray2;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }
}

