/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.util.ASN1Dump;

public final class PolicyQualifierInfo {
    private String id;
    private byte[] encoded;
    private byte[] qualifier;

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        this.encoded = (byte[])byArray.clone();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encoded);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
            this.id = ((DERObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(aSN1Sequence.getObjectAt(1));
            dEROutputStream.close();
            this.qualifier = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new IOException("parsing exception : " + exception.toString());
        }
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return null;
        }
        return (byte[])this.qualifier.clone();
    }

    public String getPolicyQualifierId() {
        return this.id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyQualifierInfo: [\n");
        stringBuffer.append("qualifierID: " + this.id + "\n");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.qualifier);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            DERObject dERObject = dERInputStream.readObject();
            stringBuffer.append("  qualifier:\n" + ASN1Dump._dumpAsString("    ", dERObject) + "\n");
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
        }
        stringBuffer.append("qualifier: " + this.id + "\n");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

