/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RSATest
implements Test {
    private RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16));
    private RSAPrivateCrtKeySpec privKeySpec = new RSAPrivateCrtKeySpec(new BigInteger("b4a7e46170574f16a97082b22be58b6a2a629798419be12872a4bdba626cfae9900f76abfb12139dce5de56564fab2b6543165a040c606887420e33d91ed7ed7", 16), new BigInteger("11", 16), new BigInteger("9f66f6b05410cd503b2709e88115d55daced94d1a34d4e32bf824d0dde6028ae79c5f07b580f5dce240d7111f7ddb130a7945cd7d957d1920994da389f490c89", 16), new BigInteger("c0a0758cdf14256f78d4708c86becdead1b50ad4ad6c5c703e2168fbf37884cb", 16), new BigInteger("f01734d7960ea60070f1b06f2bb81bfac48ff192ae18451d5e56c734a5aab8a5", 16), new BigInteger("b54bb9edff22051d9ee60f9351a48591b6500a319429c069a3e335a1d6171391", 16), new BigInteger("d3d83daf2a0cecd3367ae6f8ae1aeb82e9ac2f816c6fc483533d8297dd7884cd", 16), new BigInteger("b8f52fc6f38593dabb661d3f50f8897f8106eee68b1bce78a95b132b4e5b5d19", 16));
    private RSAPublicKeySpec isoPubKeySpec = new RSAPublicKeySpec(new BigInteger("0100000000000000000000000000000000bba2d15dbb303c8a21c5ebbcbae52b7125087920dd7cdf358ea119fd66fb064012ec8ce692f0a0b8e8321b041acd40b7", 16), new BigInteger("03", 16));
    private RSAPrivateKeySpec isoPrivKeySpec = new RSAPrivateKeySpec(new BigInteger("0100000000000000000000000000000000bba2d15dbb303c8a21c5ebbcbae52b7125087920dd7cdf358ea119fd66fb064012ec8ce692f0a0b8e8321b041acd40b7", 16), new BigInteger("2aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaac9f0783a49dd5f6c5af651f4c9d0dc9281c96a3f16a85f9572d7cc3f2d0f25a9dbf1149e4cdc32273faadd3fda5dcda7", 16));

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult perform() {
        try {
            byte[] byArray = new byte[]{84, -123, -101, 52, 44, 73, -22, 42};
            byte[][] byArrayArray = new byte[][]{Hex.decode((String)"8b427f781a2e59dd9def386f1956b996ee07f48c96880e65a368055ed8c0a8831669ef7250b40918b2b1d488547e72c84540e42bd07b03f14e226f04fbc2d929"), Hex.decode((String)"2ec6e1a1711b6c7b8cd3f6a25db21ab8bb0a5f1d6df2ef375fa708a43997730ffc7c98856dbbe36edddcdd1b2d2a53867d8355af94fea3aeec128da908e08f4c"), Hex.decode((String)"0850ac4e5a8118323200c8ed1e5aaa3d5e635172553ccac66a8e4153d35c79305c4440f11034ab147fccce21f18a50cf1c0099c08a577eb68237a91042278965"), Hex.decode((String)"00319bb9becb49f3ed1bca26d0fcf09b0b0a508e4d0bd43b350f959b72cd25b3af47d608fdcd248eada74fbe19990dbeb9bf0da4b4e1200243a14e5cab3f7e610c")};
            FixedSecureRandom fixedSecureRandom = new FixedSecureRandom();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate(this.privKeySpec);
            PublicKey publicKey = keyFactory.generatePublic(this.pubKeySpec);
            Cipher cipher = Cipher.getInstance("RSA", "BC");
            cipher.init(1, (Key)publicKey, (SecureRandom)fixedSecureRandom);
            byte[] byArray2 = cipher.doFinal(byArray);
            if (!this.arrayEquals(byArray2, byArrayArray[0])) {
                return new SimpleTestResult(false, "NoPadding test failed on encrypt expected " + new String(Hex.encode((byte[])byArrayArray[0])) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray)) {
                return new SimpleTestResult(false, "NoPadding test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher = Cipher.getInstance("RSA", "BC");
            byte[] byArray3 = ((RSAPublicKey)publicKey).getModulus().toByteArray();
            byte[] byArray4 = new byte[byArray3.length - 1];
            byArray4[0] = (byte)(byArray4[0] | 0x7F);
            cipher.init(1, (Key)publicKey, (SecureRandom)fixedSecureRandom);
            byArray2 = cipher.doFinal(byArray4);
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray4)) {
                return new SimpleTestResult(false, "NoPadding test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            cipher.init(1, (Key)publicKey, (SecureRandom)fixedSecureRandom);
            byArray2 = cipher.doFinal(byArray);
            if (!this.arrayEquals(byArray2, byArrayArray[1])) {
                return new SimpleTestResult(false, "PKCS1 test failed on encrypt expected " + new String(Hex.encode((byte[])byArrayArray[1])) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray)) {
                return new SimpleTestResult(false, "PKCS1 test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher = Cipher.getInstance("RSA/NONE/OAEPPadding", "BC");
            cipher.init(1, (Key)publicKey, (SecureRandom)fixedSecureRandom);
            byArray2 = cipher.doFinal(byArray);
            if (!this.arrayEquals(byArray2, byArrayArray[2])) {
                return new SimpleTestResult(false, "OAEP test failed on encrypt expected " + new String(Hex.encode((byte[])byArrayArray[2])) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray)) {
                return new SimpleTestResult(false, "OAEP test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            byte[] byArray5 = Hex.decode((String)"fedcba9876543210fedcba9876543210fedcba9876543210fedcba9876543210");
            PrivateKey privateKey2 = keyFactory.generatePrivate(this.isoPrivKeySpec);
            PublicKey publicKey2 = keyFactory.generatePublic(this.isoPubKeySpec);
            cipher = Cipher.getInstance("RSA/NONE/ISO9796-1Padding", "BC");
            cipher.init(1, privateKey2);
            byArray2 = cipher.doFinal(byArray5);
            if (!this.arrayEquals(byArray2, byArrayArray[3])) {
                return new SimpleTestResult(false, "ISO9796-1 test failed on encrypt expected " + new String(Hex.encode((byte[])byArrayArray[3])) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            cipher.init(2, publicKey2);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray5)) {
                return new SimpleTestResult(false, "ISO9796-1 test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(new RSAKeyGenParameterSpec(768, BigInteger.valueOf(65537L)), new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            publicKey = keyPair.getPublic();
            privateKey = keyPair.getPrivate();
            cipher.init(1, (Key)publicKey, (SecureRandom)fixedSecureRandom);
            byArray2 = cipher.doFinal(byArray);
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray2);
            if (!this.arrayEquals(byArray2, byArray)) {
                return new SimpleTestResult(false, "key generation test failed on decrypt expected " + new String(Hex.encode((byte[])byArray)) + " got " + new String(Hex.encode((byte[])byArray2)));
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "RSATest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        RSATest rSATest = new RSATest();
        TestResult testResult = rSATest.perform();
        System.out.println(testResult.toString());
    }

    private class FixedSecureRandom
    extends SecureRandom {
        byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};

        private FixedSecureRandom() {
        }

        public void nextBytes(byte[] byArray) {
            int n = 0;
            while (n + this.seed.length < byArray.length) {
                System.arraycopy(this.seed, 0, byArray, n, this.seed.length);
                n += this.seed.length;
            }
            System.arraycopy(this.seed, 0, byArray, n, byArray.length - n);
        }
    }
}

