/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathBuilderException;
import org.bouncycastle.jce.cert.CertPathBuilderResult;
import org.bouncycastle.jce.cert.CertPathBuilderSpi;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidator;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.PKIXBuilderParameters;
import org.bouncycastle.jce.cert.PKIXCertPathBuilderResult;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CertSelector;

public class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (!(certPathParameters instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXBuilderParameters instance");
        }
        PKIXBuilderParameters pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        Object var7_4 = null;
        Object var9_5 = null;
        CertPath certPath = null;
        CertPathValidatorException certPathValidatorException = null;
        try {
            CertSelector certSelector = pKIXBuilderParameters.getTargetCertConstraints();
            if (certSelector == null) {
                throw new CertPathBuilderException("targetCertConstraints must be non-null for CertPath building");
            }
            Collection collection = PKIXCertPathBuilderSpi.findCertificates(certSelector, pKIXBuilderParameters.getCertStores());
            if (collection.isEmpty()) {
                throw new CertPathBuilderException("no certificate found matching targetCertContraints");
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                arrayList.clear();
                while (x509Certificate != null) {
                    arrayList.add(x509Certificate);
                    if (PKIXCertPathBuilderSpi.findTrustAnchor(x509Certificate, pKIXBuilderParameters.getTrustAnchors()) != null) {
                        try {
                            certPath = CertificateFactory.getInstance("X.509", "BC").generateCertPath(arrayList);
                            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX", "BC");
                            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, pKIXBuilderParameters);
                            return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = certPathValidatorException2;
                            x509Certificate = null;
                            continue;
                        }
                    }
                    try {
                        x509Certificate = PKIXCertPathBuilderSpi.findIssuer(x509Certificate, pKIXBuilderParameters.getCertStores());
                    }
                    catch (CertPathValidatorException certPathValidatorException3) {
                        certPathValidatorException = certPathValidatorException3;
                        x509Certificate = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception thrown while doing CertPath building\n", exception);
        }
        if (certPath != null) {
            throw new CertPathBuilderException("found certificate chain, but could not be validated", certPathValidatorException);
        }
        throw new CertPathBuilderException("unable to find certificate chain");
    }

    private static final Collection findCertificates(CertSelector certSelector, List list) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCertificates(certSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    private static final X509Certificate findIssuer(X509Certificate x509Certificate, List list) throws CertPathValidatorException {
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(((X509Principal)x509Certificate.getIssuerDN()).getEncoded());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        Iterator iterator = PKIXCertPathBuilderSpi.findCertificates(x509CertSelector, list).iterator();
        X509Certificate x509Certificate2 = null;
        while (iterator.hasNext() && x509Certificate2 == null) {
            x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
            }
            catch (Exception exception2) {
                exception = exception2;
                x509Certificate2 = null;
            }
        }
        if (x509Certificate2 == null && exception != null) {
            throw new CertPathValidatorException("issuer found but certificate validation failed", (Throwable)exception, null, -1);
        }
        return x509Certificate2;
    }

    /*
     * Unable to fully structure code
     */
    static final TrustAnchor findTrustAnchor(X509Certificate var0, Set var1_1) throws CertPathValidatorException {
        var2_2 = var1_1.iterator();
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = new X509CertSelector();
        try {
            var6_6.setSubject(((X509Principal)var0.getIssuerDN()).getEncoded());
            if (true) ** GOTO lbl40
        }
        catch (IOException var7_7) {
            var7_7.printStackTrace();
            return null;
        }
        do {
            block15: {
                if ((var3_3 = (TrustAnchor)var2_2.next()).getTrustedCert() != null) {
                    if (var6_6.match(var3_3.getTrustedCert())) {
                        var4_4 = var3_3.getTrustedCert().getPublicKey();
                    } else {
                        var3_3 = null;
                    }
                } else if (var3_3.getCAName() != null && var3_3.getCAPublicKey() != null) {
                    try {
                        var7_8 = X509Name.getInstance(var0.getIssuerDN());
                        var8_10 = X509Name.getInstance(var3_3.getCAName());
                        if (var7_8.equals(var8_10)) {
                            var4_4 = var3_3.getCAPublicKey();
                            break block15;
                        }
                        var3_3 = null;
                    }
                    catch (IllegalArgumentException v0) {
                        var3_3 = null;
                    }
                } else {
                    var3_3 = null;
                }
            }
            if (var4_4 == null) continue;
            try {
                var0.verify(var4_4);
            }
            catch (Exception var7_9) {
                var5_5 = var7_9;
                var3_3 = null;
            }
lbl40:
            // 4 sources

        } while (var2_2.hasNext() && var3_3 == null);
        if (var3_3 == null && var5_5 != null) {
            throw new CertPathValidatorException("TrustAnchor found put certificate validation failed", var5_5, null, -1);
        }
        return var3_3;
    }
}

