/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.SecretKey;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;

public class EnvelopedDataTest
extends TestCase {
    public boolean DEBUG = true;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$EnvelopedDataTest;

    public EnvelopedDataTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$EnvelopedDataTest == null ? (class$org$bouncycastle$cms$test$EnvelopedDataTest = EnvelopedDataTest.class$("org.bouncycastle.cms.test.EnvelopedDataTest")) : class$org$bouncycastle$cms$test$EnvelopedDataTest));
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$cms$test$EnvelopedDataTest == null ? (class$org$bouncycastle$cms$test$EnvelopedDataTest = EnvelopedDataTest.class$("org.bouncycastle.cms.test.EnvelopedDataTest")) : class$org$bouncycastle$cms$test$EnvelopedDataTest);
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void testKeyTrans() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testKeyTransAES128() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "2.16.840.1.101.3.4.2", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testKeyTransAES192() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "2.16.840.1.101.3.4.22", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray2 = recipientInformation.getContent(keyPair2.getPrivate(), "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testKeyTransAES256() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            String string = "O=Bouncy Castle, C=AU";
            KeyPair keyPair = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate = CMSTestUtil.makeCertificate(keyPair, string, keyPair, string);
            String string2 = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair2 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate2 = CMSTestUtil.makeCertificate(keyPair2, string2, keyPair, string);
            String string3 = "CN=Doug, OU=Sales, O=Bouncy Castle, C=AU";
            KeyPair keyPair3 = CMSTestUtil.makeKeyPair();
            X509Certificate x509Certificate3 = CMSTestUtil.makeCertificate(keyPair3, string3, keyPair, string);
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            cMSEnvelopedDataGenerator.addKeyTransRecipient(x509Certificate3);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "2.16.840.1.101.3.4.42", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray2 = recipientInformation.getContent(keyPair3.getPrivate(), "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray2));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testDESKEK() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            SecretKey secretKey = CMSTestUtil.makeDesede192Key();
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
            cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void testRC2KEK() {
        try {
            byte[] byArray = "WallaWallaWashington".getBytes();
            SecretKey secretKey = CMSTestUtil.makeRC2128Key();
            CMSEnvelopedDataGenerator cMSEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            byte[] byArray2 = new byte[]{1, 2, 3, 4, 5};
            cMSEnvelopedDataGenerator.addKEKRecipient(secretKey, byArray2);
            CMSEnvelopedData cMSEnvelopedData = cMSEnvelopedDataGenerator.generate(new CMSProcessableByteArray(byArray), "1.2.840.113549.3.7", "BC");
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RecipientInformation recipientInformation = (RecipientInformation)iterator.next();
                byte[] byArray3 = recipientInformation.getContent(secretKey, "BC");
                Assert.assertEquals((boolean)true, (boolean)Arrays.equals(byArray, byArray3));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

