/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.util.encoders.Base64;

public class SMIMEEnvelopedGenerator
extends SMIMEGenerator {
    public static final String DES_EDE3_CBC = "1.2.840.113549.3.7";
    public static final String RC2_CBC = "1.2.840.113549.3.2";
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = "2.16.840.1.101.3.4.2";
    public static final String AES192_CBC = "2.16.840.1.101.3.4.22";
    public static final String AES256_CBC = "2.16.840.1.101.3.4.42";
    private CMSEnvelopedDataGenerator fact = new CMSEnvelopedDataGenerator();

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        this.fact.addKeyTransRecipient(x509Certificate);
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.fact.addKeyTransRecipient(publicKey, byArray);
    }

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        CMSEnvelopedData cMSEnvelopedData;
        try {
            cMSEnvelopedData = n == 0 ? this.fact.generate(new CMSProcessableBodyPart((BodyPart)mimeBodyPart), string, string2) : this.fact.generate(new CMSProcessableBodyPart((BodyPart)mimeBodyPart), string, n, string2);
        }
        catch (CMSException cMSException) {
            throw new SMIMEException(cMSException.getMessage(), cMSException.getUnderlyingException());
        }
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.addHeader("Content-Type", "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data");
        internetHeaders.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
        internetHeaders.addHeader("Content-Description", "S/MIME Encrypted Message");
        try {
            MimeBodyPart mimeBodyPart2;
            if (this.useBase64) {
                internetHeaders.addHeader("Content-Transfer-Encoding", "base64");
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, Base64.encode((byte[])cMSEnvelopedData.getEncoded()));
            } else {
                internetHeaders.addHeader("Content-Transfer-Encoding", this.encoding);
                mimeBodyPart2 = new MimeBodyPart(internetHeaders, cMSEnvelopedData.getEncoded());
            }
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception generating encoded content", iOException);
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string, 0, string2);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string, 0, string2);
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string, n, string2);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string, n, string2);
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

