@echo off
rem : 
rem : build script for 1.1
rem :

set DEVEL_ROOT=g:\devel\crypto
set SRC_ROOT=%DEVEL_ROOT%\src
set OUTPUT_CLASSES=%DEVEL_ROOT%\classes
set JDK11_ROOT=%DEVEL_ROOT%\jdk1.1

set DR=%DEVEL_ROOT%
set SR=%SRC_ROOT%
set OC=%OUTPUT_CLASSES%
set J1=%JDK11_ROOT%

rem : because it's 1.1, and -classpath eats the system classpath
rem : we have to make it work differently.  gak. -- jon
set CLASSPATH=%OC%

goto NODEL
cd %OC%
deltree /y *
:NODEL

:COMPAT
rem : The JDK1.1 compatibility classes
cd %J1%\java
javac -d %OC% lang\*.java util\*.java


rem : do some gymnastics to make this work under windows
rem : I have no idea why this fails on a single line
cd %J1%\java\security
javac -d %OC% UnrecoverableKeyException.java SecurityUtil.java KeyStoreSpi.java KeyStoreException.java KeyStore.java KeyFactory.java KeyFactorySpi.java InvalidAlgorithmParameterException.java GeneralSecurityException.java AlgorithmParametersSpi.java AlgorithmParameters.java spec\*.java cert\*.java interfaces\*.java
javac -d %OC% AlgorithmParameterGenerator.java AlgorithmParameterGeneratorSpi.java

:UTIL
cd %SR%\org\bouncycastle\util\
javac -d %OC% encoders\*.java test\*.java

:MATH
cd %SR%\org\bouncycastle\math\ec\
javac -d %OC% *.java

rem : more gymnastics for the 1.1 javac.  it's not all that
rem : great a tool to use, and I'm not all that happy about 
rem : it because it's now heading towards midnight and it's
rem : still not working properly.  I wish I was using Unix.
rem : *sigh*

:ASN1
cd %SR%\org\bouncycastle\asn1\
javac -d %OC% *.java 
javac -d %OC% util\*.java
javac -d %OC% pkcs\PKCSObjectIdentifiers.java
javac -d %OC% x509\AlgorithmIdentifier.java
javac -d %OC% pkcs\*.java
javac -d %OC% x509\*.java x9\*.java 
javac -d %OC% test\*.java

:CRYPTO
cd %SR%\org\bouncycastle\crypto
javac -d %OC% *.java
javac -d %OC% params\*.java signers\*.java digests\*.java modes\*.java macs\*.java encodings\*.java io\*.java engines\*.java agreement\*.java generators\*.java
javac -d %OC% test\*.java

:JAVAXCRYPTO
cd %SR%\javax\crypto
javac -d %OC%  *.java interfaces\*.java spec\*.java

:PROVIDER
rem : no work to be done in the jce directory
rem : cd %SR%\org\bouncycastle\jce
rem : javac -d %OC%  *.java 
cd %SR%\org\bouncycastle\jce\interfaces\
javac -d %OC% *.java
cd %SR%\org\bouncycastle\jce\spec\
javac -d %OC% *.java
cd %SR%\org\bouncycastle\jce\provider\
javac -d %OC% JCEBlockCipher.java JCEDHKeyAgreement.java JCEDHPrivateKey.java JCEDHPublicKey.java JCEKeyGenerator.java JCEMac.java JCEPBEKey.java JCERSACipher.java JCERSAPrivateKey.java JCERSAPrivateCrtKey.java JCERSAPublicKey.java JCESecretKeyFactory.java JCEStreamCipher.java JDKAlgorithmParameters.java JDKDigestSignature.java JDKKeyFactory.java JDKKeyPairGenerator.java JDKKeyStore.java JDKMessageDigest.java WrapCipherSpi.java BouncyCastleProvider.java PBE.java RSAUtil.java

rem goto NOTEST
echo "lightweight regression test"
java  org.bouncycastle.crypto.test.RegressionTest
echo "provider regression test"
java  org.bouncycastle.jce.provider.test.RegressionTest
:NOTEST

:END
cd %SR%
cd ..
