package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class OCSPRequest
    implements DEREncodable
{
	TBSRequest		tbsRequest;
	Signature		optionalSignature;

    public OCSPRequest(
        TBSRequest  tbsRequest,
        Signature   optionalSignature)
    {
        this.tbsRequest = tbsRequest;
        this.optionalSignature = optionalSignature;
    }

	public OCSPRequest(
		ASN1Sequence	seq)
	{
		tbsRequest = TBSRequest.getInstance(seq.getObjectAt(0));

		if (seq.size() == 2)
		{
			optionalSignature = Signature.getInstance(
								(ASN1TaggedObject)seq.getObjectAt(1), true);
		}
	}

	public TBSRequest getTbsRequest()
	{
		return tbsRequest;
	}

	public Signature getOptionalSignature()
	{
		return optionalSignature;
	}

	/**
	 * <pre>
	 * OCSPRequest     ::=     SEQUENCE {
	 *     tbsRequest                  TBSRequest,
	 *     optionalSignature   [0]     EXPLICIT Signature OPTIONAL }
	 * </pre>
	 */
	public DERObject getDERObject()
	{
		ASN1EncodableVector	v = new ASN1EncodableVector();

		v.add(tbsRequest);

		if (optionalSignature != null)
		{
			v.add(new DERTaggedObject(true, 0, optionalSignature));
		}

		return new DERSequence(v);
	}
}
