package org.bouncycastle.asn1.ocsp;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Name;

public class ServiceLocator
    implements DEREncodable
{
	X509Name	issuer;
	DERObject	locator;

	/**
	 * <pre>
     * ServiceLocator ::= SEQUENCE {
     *     issuer    Name,
     *     locator   AuthorityInfoAccessSyntax OPTIONAL }
	 * </pre>
	 */
	public DERObject getDERObject()
	{
		ASN1EncodableVector	v = new ASN1EncodableVector();

		v.add(issuer);

		if (locator != null)
		{
			v.add(locator);
		}

		return new DERSequence(v);
	}
}
