package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

/**
 * X.690 test example
 */
public class OIDTest
	implements Test
{
	byte[]	req = Hex.decode("0603813403");

	public String getName()
	{
		return "OID";
	}
	
	public TestResult perform()
	{
		try
		{
			ByteArrayInputStream	bIn = new ByteArrayInputStream(req);
			DERInputStream			dIn = new DERInputStream(bIn);

			DERObjectIdentifier 	o = new DERObjectIdentifier("2.100.3");

			ByteArrayOutputStream	bOut = new ByteArrayOutputStream();
			DEROutputStream			dOut = new DEROutputStream(bOut);

			dOut.writeObject(o);

			byte[]					bytes = bOut.toByteArray();

			if (bytes.length != req.length)
			{
        		return new SimpleTestResult(false, getName() + ": failed length test");
			}

			for (int i = 0; i != req.length; i++)
			{
				if (bytes[i] != req[i])
				{
					return new SimpleTestResult(false, getName() + ": failed comparison test");
				}
			}
		}
		catch (Exception e)
		{
        	return new SimpleTestResult(false, getName() + ": Exception - " + e.toString());
		}

        return new SimpleTestResult(true, getName() + ": Okay");
    }

    public static void main(
        String[]    args)
    {
        Test    test = new OIDTest();

        TestResult  result = test.perform();

        System.out.println(result);
    }
}
