/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.CRC24;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable = new byte[128];
    InputStream in;
    boolean start = true;
    int[] outBuf = new int[3];
    int bufPtr = 3;
    CRC24 crc = new CRC24();
    boolean crcFound = false;

    static {
        int n = 65;
        while (n <= 90) {
            ArmoredInputStream.decodingTable[n] = (byte)(n - 65);
            ++n;
        }
        int n2 = 97;
        while (n2 <= 122) {
            ArmoredInputStream.decodingTable[n2] = (byte)(n2 - 97 + 26);
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            ArmoredInputStream.decodingTable[n3] = (byte)(n3 - 48 + 52);
            ++n3;
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }

    public ArmoredInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    private int decode(int n, int n2, int n3, int n4, int[] nArray) throws EOFException {
        if (n4 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (n3 == 61) {
            int n5 = decodingTable[n] & 0xFF;
            int n6 = decodingTable[n2] & 0xFF;
            nArray[2] = (n5 << 2 | n6 >> 4) & 0xFF;
            return 2;
        }
        if (n4 == 61) {
            byte by = decodingTable[n];
            byte by2 = decodingTable[n2];
            byte by3 = decodingTable[n3];
            nArray[1] = (by << 2 | by2 >> 4) & 0xFF;
            nArray[2] = (by2 << 4 | by3 >> 2) & 0xFF;
            return 1;
        }
        byte by = decodingTable[n];
        byte by4 = decodingTable[n2];
        byte by5 = decodingTable[n3];
        byte by6 = decodingTable[n4];
        nArray[0] = (by << 2 | by4 >> 4) & 0xFF;
        nArray[1] = (by4 << 4 | by5 >> 2) & 0xFF;
        nArray[2] = (by5 << 6 | by6) & 0xFF;
        return 0;
    }

    private boolean parseHeaders() throws IOException {
        int n;
        int n2 = 0;
        boolean bl = false;
        while ((n = this.in.read()) >= 0) {
            if (n == 45 && (n2 == 0 || n2 == 10)) {
                bl = true;
                break;
            }
            n2 = n;
        }
        if (bl) {
            while ((n = this.in.read()) >= 0) {
                if (n2 == 10 && n == 10) break;
                if (n == 13) continue;
                n2 = n;
            }
        }
        return bl;
    }

    public int read() throws IOException {
        int n;
        if (this.start) {
            this.parseHeaders();
            this.start = false;
        }
        if (this.bufPtr > 2) {
            n = this.in.read();
            if (n == 10 || n == 13) {
                n = this.in.read();
                if (n == 10) {
                    n = this.in.read();
                }
                if (n < 0) {
                    return -1;
                }
                if (n == 61) {
                    this.bufPtr = this.decode(this.in.read(), this.in.read(), this.in.read(), this.in.read(), this.outBuf);
                    if (this.bufPtr == 0) {
                        int n2 = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                        this.crcFound = true;
                        if (n2 != this.crc.getValue()) {
                            throw new IOException("crc check failed in armored message.");
                        }
                        return -1;
                    }
                    throw new IOException("no crc found in armored message.");
                }
                if (n == 45) {
                    while ((n = this.in.read()) >= 0) {
                        if (n == 10) break;
                    }
                    if (!this.crcFound) {
                        throw new IOException("crc check not found.");
                    }
                    return -1;
                }
                this.bufPtr = this.decode(n, this.in.read(), this.in.read(), this.in.read(), this.outBuf);
            } else if (n >= 0) {
                this.bufPtr = this.decode(n, this.in.read(), this.in.read(), this.in.read(), this.outBuf);
            } else {
                return -1;
            }
        }
        n = this.outBuf[this.bufPtr++];
        this.crc.update(n);
        return n;
    }
}

