/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private long keyID;
    private byte[] fingerPrint;
    PublicKeyPacket publicPk;
    ArrayList ids;
    ArrayList idSigs;

    PGPPublicKey(PublicKeyPacket publicKeyPacket, MessageDigest messageDigest, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        this.publicPk = publicKeyPacket;
        this.ids = arrayList;
        this.idSigs = arrayList2;
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded());
            messageDigest.update(new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded());
        } else {
            byte[] byArray = publicKeyPacket.getEncodedContents();
            messageDigest.update((byte)-103);
            messageDigest.update((byte)(byArray.length >> 8));
            messageDigest.update((byte)byArray.length);
            messageDigest.update(byArray);
            this.fingerPrint = messageDigest.digest();
            this.keyID = (long)(this.fingerPrint[this.fingerPrint.length - 8] & 0xFF) << 56 | (long)(this.fingerPrint[this.fingerPrint.length - 7] & 0xFF) << 48 | (long)(this.fingerPrint[this.fingerPrint.length - 6] & 0xFF) << 40 | (long)(this.fingerPrint[this.fingerPrint.length - 5] & 0xFF) << 32 | (long)(this.fingerPrint[this.fingerPrint.length - 4] & 0xFF) << 24 | (long)(this.fingerPrint[this.fingerPrint.length - 3] & 0xFF) << 16 | (long)(this.fingerPrint[this.fingerPrint.length - 2] & 0xFF) << 8 | (long)(this.fingerPrint[this.fingerPrint.length - 1] & 0xFF);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        int n = 0;
        while (n != this.ids.size()) {
            String string = (String)this.ids.get(n);
            bCPGOutputStream.writePacket(new UserIDPacket(string));
            ArrayList arrayList = (ArrayList)this.idSigs.get(n);
            int n2 = 0;
            while (n2 != arrayList.size()) {
                ((PGPSignature)arrayList.get(n2)).encode(bCPGOutputStream);
                ++n2;
            }
            ++n;
        }
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public PublicKey getKey(String string) throws PGPException, NoSuchProviderException {
        try {
            switch (this.publicPk.getAlgorithm()) {
                case 1: 
                case 2: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)this.publicPk.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", string);
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)this.publicPk.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA", string);
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)this.publicPk.getKey();
                    ElGamalPublicKeySpec elGamalPublicKeySpec = new ElGamalPublicKeySpec(elGamalPublicBCPGKey.getY(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", string);
                    return keyFactory.generatePublic((KeySpec)elGamalPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public long getKeyID() {
        return this.keyID;
    }

    public Iterator getSignaturesForID(String string) {
        int n = 0;
        while (n != this.ids.size()) {
            if (string.equals(this.ids.get(n))) {
                return ((AbstractList)((ArrayList)this.idSigs.get(n))).iterator();
            }
            ++n;
        }
        return null;
    }

    public Iterator getUserIDs() {
        return ((AbstractList)this.ids).iterator();
    }
}

