package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class DistributionPointName
    implements DEREncodable
{
    DEREncodable        name;
    int                 type;

    public static final int FULL_NAME = 0;
    public static final int NAME_RELATIVE_TO_CRL_ISSUER = 1;

    public DistributionPointName(
        int             type,
        DEREncodable    name)
    {
        this.type = type;
        this.name = name;
    }

    /**
     * <pre>
     * DistributionPointName ::= CHOICE {
     *     fullName                 [0] GeneralNames,
     *     nameRelativeToCRLIssuer  [1] RelativeDistinguishedName
     * }
     * </pre>
     */
    public DERObject getDERObject()
    {
        if (name instanceof ASN1Sequence)
        {
            return new DERTaggedObject(true, type, name);
        }
        else
        {
            return new DERTaggedObject(false, type, name);
        }
    }
}
