/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPBEEncryptedData
implements PacketTags,
PublicKeyAlgorithmTags,
SymmetricKeyAlgorithmTags,
HashAlgorithmTags {
    SymmetricKeyEncSessionPacket keyData;
    InputStreamPacket encData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        this.keyData = symmetricKeyEncSessionPacket;
        this.encData = inputStreamPacket;
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public InputStream getDataStream(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(PGPUtil.getSymmetricCipherName(this.keyData.getEncAlgorithm()) + "/PGPCFBwithIV/NoPadding", string);
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (Exception exception) {
            throw new PGPException("exception creating cipher", exception);
        }
        if (cipher != null) {
            try {
                SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K(), cArray, string);
                BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                cipher.init(2, secretKey);
                return new CipherInputStream(bCPGInputStream, cipher);
            }
            catch (Exception exception) {
                throw new PGPException("Exception creating cipher", exception);
            }
        }
        return this.encData.getInputStream();
    }
}

