/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class MD5DigestTest
implements Test {
    private static String testVec1 = "";
    private static String resVec1 = "d41d8cd98f00b204e9800998ecf8427e";
    private static String testVec2 = "61";
    private static String resVec2 = "0cc175b9c0f1b6a831c399e269772661";
    private static String testVec3 = "616263";
    private static String resVec3 = "900150983cd24fb0d6963f7d28e17f72";
    private static String testVec4 = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
    private static String resVec4 = "c3fcd3d76192e4007dfb496cca67e13b";

    public String getName() {
        return "MD5";
    }

    public static void main(String[] stringArray) {
        MD5DigestTest mD5DigestTest = new MD5DigestTest();
        TestResult testResult = mD5DigestTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        MD5Digest mD5Digest = new MD5Digest();
        byte[] byArray = new byte[mD5Digest.getDigestSize()];
        mD5Digest.doFinal(byArray, 0);
        String string = new String(Hex.encode((byte[])byArray));
        if (!resVec1.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byte[] byArray2 = Hex.decode((String)testVec2);
        mD5Digest.update(byArray2, 0, byArray2.length);
        mD5Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec2.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec3);
        mD5Digest.update(byArray2, 0, byArray2.length);
        mD5Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec3.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        mD5Digest.update(byArray2, 0, byArray2.length);
        mD5Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        byArray2 = Hex.decode((String)testVec4);
        mD5Digest.update(byArray2, 0, byArray2.length / 2);
        MD5Digest mD5Digest2 = new MD5Digest(mD5Digest);
        mD5Digest.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        mD5Digest.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        mD5Digest2.update(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
        mD5Digest2.doFinal(byArray, 0);
        string = new String(Hex.encode((byte[])byArray));
        if (!resVec4.equals(string)) {
            return new SimpleTestResult(false, "MD5 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + string);
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

