/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidator;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.PKIXParameters;
import org.bouncycastle.jce.cert.PolicyNode;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertPathValidatorTest
implements Test {
    public String getName() {
        return "CertPathValidator";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertPathValidatorTest certPathValidatorTest = new CertPathValidatorTest();
        TestResult testResult = certPathValidatorTest.perform();
        System.out.println(testResult.toString());
    }

    public TestResult perform() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance((String)"X.509", (String)"BC");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate x509Certificate3 = (X509Certificate)certificateFactory.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL x509CRL2 = (X509CRL)certificateFactory.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> arrayList = new ArrayList<X509Extension>();
            arrayList.add(x509Certificate);
            arrayList.add(x509Certificate2);
            arrayList.add(x509Certificate3);
            arrayList.add(x509CRL);
            arrayList.add(x509CRL2);
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(arrayList);
            CertStore certStore = CertStore.getInstance((String)"Collection", (CertStoreParameters)collectionCertStoreParameters);
            Calendar calendar = Calendar.getInstance();
            calendar.set(2002, 2, 21, 2, 21, 10);
            ArrayList<X509Certificate> arrayList2 = new ArrayList<X509Certificate>();
            arrayList2.add(x509Certificate3);
            arrayList2.add(x509Certificate2);
            CertPath certPath = CertificateFactory.getInstance((String)"X.509", (String)"BC").generateCertPath(arrayList2);
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            hashSet.add(new TrustAnchor(x509Certificate, null));
            CertPathValidator certPathValidator = CertPathValidator.getInstance((String)"PKIX", (String)"BC");
            PKIXParameters pKIXParameters = new PKIXParameters(hashSet);
            pKIXParameters.addCertStore(certStore);
            pKIXParameters.setDate(calendar.getTime());
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, (CertPathParameters)pKIXParameters);
            PolicyNode policyNode = pKIXCertPathValidatorResult.getPolicyTree();
            PublicKey publicKey = pKIXCertPathValidatorResult.getPublicKey();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

