/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;

public abstract class ASN1Sequence
extends DERObject {
    private Vector seq = new Vector();

    protected void addObject(DEREncodable dEREncodable) {
        this.seq.addElement(dEREncodable);
    }

    abstract void encode(DEROutputStream var1) throws IOException;

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)object;
        if (this.size() != aSN1Sequence.size()) {
            return false;
        }
        Enumeration enumeration = this.getObjects();
        Enumeration enumeration2 = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = enumeration2.nextElement();
            if (e != null && e2 != null) {
                if (e.equals(e2)) continue;
                return false;
            }
            if (e == null && e2 == null) continue;
            return false;
        }
        return true;
    }

    public static ASN1Sequence getInstance(Object object) {
        if (object == null || object instanceof ASN1Sequence) {
            return (ASN1Sequence)object;
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (bl) {
            if (!aSN1TaggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1TaggedObject instanceof BERTaggedObject) {
                return new BERSequence(aSN1TaggedObject.getObject());
            }
            return new DERSequence(aSN1TaggedObject.getObject());
        }
        if (aSN1TaggedObject.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstanceFromTagged");
    }

    public DEREncodable getObjectAt(int n) {
        return (DEREncodable)this.seq.elementAt(n);
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public int hashCode() {
        Enumeration enumeration = this.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    public int size() {
        return this.seq.size();
    }
}

