/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.cert.CertPathBuilderException;
import org.bouncycastle.jce.cert.CertPathBuilderResult;
import org.bouncycastle.jce.cert.CertPathBuilderSpi;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertUtil;

public class CertPathBuilder {
    private CertPathBuilderSpi builderSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi certPathBuilderSpi, Provider provider, String string) {
        this.builderSpi = certPathBuilderSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.builderSpi.engineBuild(certPathParameters);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final String getDefaultType() {
        String string = null;
        string = Security.getProperty("certpathbuilder.type");
        if (string == null || string.length() <= 0) {
            return "PKIX";
        }
        return string;
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        try {
            CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, null);
            if (implementation != null) {
                return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {}
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, string2);
        if (implementation != null) {
            return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, provider);
        if (implementation != null) {
            return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), provider, string);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

