/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.CompressedDataPacket;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.LiteralDataPacket;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.bcpg.ModDetectionCodePacket;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketTags;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.UserIDPacket;

public class BCPGInputStream
extends InputStream
implements PacketTags {
    InputStream in;
    boolean next = false;
    int nextB;

    public BCPGInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        if (this.next) {
            this.next = false;
            return this.nextB;
        }
        return this.in.read();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > 0) {
            n3 = this.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            byArray[n] = (byte)n3;
            ++n;
            --n2;
        }
        while (n2 > 0) {
            n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n += n3;
            n2 -= n3;
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public int nextPacketTag() throws IOException {
        if (!this.next) {
            this.nextB = this.in.read();
        }
        this.next = true;
        if (this.nextB >= 0) {
            if ((this.nextB & 0x40) != 0) {
                return this.nextB & 0x3F;
            }
            return (this.nextB & 0x3F) >> 2;
        }
        return this.nextB;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Packet readPacket() throws IOException {
        boolean bl;
        int n;
        int n2;
        block32: {
            int n3;
            block33: {
                n3 = this.read();
                if (n3 < 0) {
                    return null;
                }
                if ((n3 & 0x80) == 0) {
                    throw new IOException("invalid header encountered");
                }
                boolean bl2 = (n3 & 0x40) != 0;
                n2 = 0;
                n = 0;
                bl = false;
                if (!bl2) break block33;
                n2 = n3 & 0x3F;
                int n4 = this.read();
                if (n4 < 192) {
                    n = n4;
                    break block32;
                } else if (n4 < 223) {
                    n = (n4 - 192 << 8) + this.in.read() + 192;
                    break block32;
                } else {
                    if (n4 != 255) {
                        bl = true;
                        n = 1 << (n4 & 0x1F);
                        throw new IOException("partial packets not currently supported");
                    }
                    n = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
                }
                break block32;
            }
            int n5 = n3 & 3;
            n2 = (n3 & 0x3F) >> 2;
            switch (n5) {
                case 0: {
                    n = this.read();
                    break;
                }
                case 1: {
                    n = this.read() << 8 | this.read();
                    break;
                }
                case 2: {
                    n = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new IOException("unknown length type encountered");
                }
            }
        }
        Object var6_8 = null;
        BCPGInputStream bCPGInputStream = n == 0 && bl ? this : new BCPGInputStream(new PartialInputStream(this, bl, n));
        switch (n2) {
            case 0: {
                return new InputStreamPacket(bCPGInputStream);
            }
            case 1: {
                return new PublicKeyEncSessionPacket(bCPGInputStream);
            }
            case 2: {
                return new SignaturePacket(bCPGInputStream);
            }
            case 3: {
                return new SymmetricKeyEncSessionPacket(bCPGInputStream);
            }
            case 4: {
                return new OnePassSignaturePacket(bCPGInputStream);
            }
            case 5: {
                return new SecretKeyPacket(bCPGInputStream);
            }
            case 6: {
                return new PublicKeyPacket(bCPGInputStream);
            }
            case 7: {
                return new SecretSubkeyPacket(bCPGInputStream);
            }
            case 8: {
                return new CompressedDataPacket(bCPGInputStream);
            }
            case 9: {
                return new SymmetricEncDataPacket(bCPGInputStream);
            }
            case 10: {
                return new MarkerPacket(bCPGInputStream);
            }
            case 11: {
                return new LiteralDataPacket(bCPGInputStream);
            }
            case 12: {
                return new InputStreamPacket(bCPGInputStream);
            }
            case 13: {
                return new UserIDPacket(bCPGInputStream);
            }
            case 14: {
                return new PublicSubkeyPacket(bCPGInputStream);
            }
            case 18: {
                return new SymmetricEncIntegrityPacket(bCPGInputStream);
            }
            case 19: {
                return new ModDetectionCodePacket(bCPGInputStream);
            }
        }
        throw new IOException("unknown packet type encountered: " + n2);
    }

    private static class PartialInputStream
    extends InputStream {
        private BCPGInputStream in;
        private boolean partial;
        private int dataLength;

        PartialInputStream(BCPGInputStream bCPGInputStream, boolean bl, int n) {
            this.in = bCPGInputStream;
            this.partial = bl;
            this.dataLength = n;
        }

        public int available() throws IOException {
            int n = this.in.available();
            if (n <= this.dataLength) {
                return n;
            }
            return this.dataLength;
        }

        public int read() throws IOException {
            if (this.dataLength > 0) {
                --this.dataLength;
                return this.in.read();
            }
            return -1;
        }
    }
}

