/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private String algorithm;
    private byte[] key;

    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Bad offset/len");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null algorithm string passed");
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("null key passed");
        }
        if (string == null) {
            throw new IllegalArgumentException("null algorithm passed");
        }
        this.key = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
        this.algorithm = string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SecretKeySpec)) {
            return false;
        }
        SecretKeySpec secretKeySpec = (SecretKeySpec)object;
        if (!this.algorithm.equalsIgnoreCase(secretKeySpec.algorithm)) {
            return false;
        }
        if (this.key.length != secretKeySpec.key.length) {
            return false;
        }
        int n = 0;
        while (n != this.key.length) {
            if (this.key[n] != secretKeySpec.key[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.key.length];
        System.arraycopy(this.key, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = this.algorithm.toUpperCase().hashCode();
        int n2 = 0;
        while (n2 != this.key.length) {
            n ^= this.key[n2] << 8 * (n2 % 4);
            ++n2;
        }
        return n;
    }
}

