/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class PolicyInformation
implements DEREncodable {
    private DERObjectIdentifier policyIdentifier;
    private ASN1Sequence policyQualifiers;

    public PolicyInformation(ASN1Sequence aSN1Sequence) {
        this.policyIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.policyQualifiers = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        }
    }

    public PolicyInformation(DERObjectIdentifier dERObjectIdentifier) {
        this.policyIdentifier = dERObjectIdentifier;
    }

    public PolicyInformation(DERObjectIdentifier dERObjectIdentifier, ASN1Sequence aSN1Sequence) {
        this.policyIdentifier = dERObjectIdentifier;
        this.policyQualifiers = aSN1Sequence;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            aSN1EncodableVector.add(this.policyQualifiers);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public static PolicyInformation getInstance(Object object) {
        if (object == null || object instanceof PolicyInformation) {
            return (PolicyInformation)object;
        }
        return new PolicyInformation(ASN1Sequence.getInstance(object));
    }

    public DERObjectIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public ASN1Sequence getPolicyQualifiers() {
        return this.policyQualifiers;
    }
}

