package org.bouncycastle.cms;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SignerInformationStore
{
    private HashMap table = new HashMap();

    public SignerInformationStore(
        Collection  signerInfos)
    {
        Iterator    it = signerInfos.iterator();

        while (it.hasNext())
        {
            SignerInformation   signer = (SignerInformation)it.next();

            table.put(signer.getSID(), signer);
        }
    }

    public SignerInformation get(
        SignerId        selector)
    {
        return (SignerInformation)table.get(selector);
    }

    public int size()
    {
        return table.size();
    }

    public Collection getSigners()
    {
        return table.values();
    }
}
