package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;

import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

public class SMIMEUtil
{
    /**
     * return the MimeBodyPart described in the raw bytes provided in content
     */
    public static MimeBodyPart toMimeBodyPart(
        byte[]    content)
        throws SMIMEException
    {
        ByteArrayInputStream bIn = new ByteArrayInputStream(content);

        try
        {
            MimeBodyPart part = new MimeBodyPart(bIn);

            return part;
        }
        catch (MessagingException e)
        {
            throw new SMIMEException("exception creating body part.", e);
        }
    }
}
