/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

class CMSProcessableBodyPartInbound
implements CMSProcessable {
    private BodyPart bodyPart;
    private byte[] buf = new byte[4];

    public CMSProcessableBodyPartInbound(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            if (this.bodyPart instanceof MimeBodyPart) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)this.bodyPart;
                String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
                if (stringArray == null || !stringArray[0].equalsIgnoreCase("base64") && !stringArray[0].equalsIgnoreCase("quoted-printable")) {
                    this.bodyPart.writeTo(outputStream);
                    outputStream.flush();
                    return;
                }
                LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    lineOutputStream.writeln((String)enumeration.nextElement());
                }
                lineOutputStream.writeln();
                lineOutputStream.flush();
                InputStream inputStream = mimeBodyPart.getRawInputStream();
                CRLFOutputStream cRLFOutputStream = new CRLFOutputStream(outputStream);
                int n = 0;
                while ((n = inputStream.read(this.buf, 0, this.buf.length)) > 0) {
                    cRLFOutputStream.write(this.buf, 0, n);
                }
                cRLFOutputStream.flush();
            } else {
                this.bodyPart.writeTo(outputStream);
            }
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream.", (Exception)((Object)messagingException));
        }
    }

    public Object getContent() {
        return this.bodyPart;
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string);
                this.out.write(byArray);
                this.out.write(newline);
                return;
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
                return;
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }

    private static class CRLFOutputStream
    extends FilterOutputStream {
        protected int lastb = -1;
        protected static byte[] newline = new byte[2];

        public CRLFOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            if (n == 13) {
                this.out.write(newline);
            } else if (n == 10) {
                if (this.lastb != 13) {
                    this.out.write(newline);
                }
            } else {
                this.out.write(n);
            }
            this.lastb = n;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n;
            n2 += n;
            int n4 = n3;
            while (n4 < n2) {
                if (byArray[n4] == 13) {
                    this.out.write(byArray, n3, n4 - n3);
                    this.out.write(newline);
                    n3 = n4 + 1;
                } else if (byArray[n4] == 10) {
                    if (this.lastb != 13) {
                        this.out.write(byArray, n3, n4 - n3);
                        this.out.write(newline);
                    }
                    n3 = n4 + 1;
                }
                this.lastb = byArray[n4];
                ++n4;
            }
            if (n2 - n3 > 0) {
                this.out.write(byArray, n3, n2 - n3);
            }
        }

        public void writeln() throws IOException {
            this.out.write(newline);
        }

        static {
            CRLFOutputStream.newline[0] = 13;
            CRLFOutputStream.newline[1] = 10;
        }
    }
}

