/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PacketTags;

public class BCPGOutputStream
extends OutputStream
implements PacketTags,
CompressionAlgorithmTags {
    OutputStream out;
    boolean oldPackets;

    public BCPGOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public BCPGOutputStream(OutputStream outputStream, int n) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, true, true, 0L);
    }

    public BCPGOutputStream(OutputStream outputStream, int n, long l) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, false, false, l);
    }

    public BCPGOutputStream(OutputStream outputStream, int n, long l, boolean bl) throws IOException {
        this.out = outputStream;
        this.writeHeader(n, bl, false, l);
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    private void writeHeader(int n, boolean bl, boolean bl2, long l) throws IOException {
        int n2 = 128;
        if (bl) {
            n2 |= n << 2;
            if (bl2) {
                this.write(n2 | 3);
            } else if (l <= 255L) {
                this.write(n2);
                this.write((byte)l);
            } else if (l <= 65535L) {
                this.write(n2 | 1);
                this.write((byte)(l >> 8));
                this.write((byte)l);
            } else {
                this.write(n2 | 2);
                this.write((byte)(l >> 24));
                this.write((byte)(l >> 16));
                this.write((byte)(l >> 8));
                this.write((byte)l);
            }
        } else {
            n2 |= 0x40 | n;
            if (bl2) {
                throw new RuntimeException("not implemented");
            }
            this.write(n2);
            if (l < 192L) {
                this.write((byte)l);
            } else if (l < 8383L) {
                this.write((byte)(l - 192L >> 8));
                this.write((byte)l);
            } else {
                this.write(255);
                this.write((byte)(l >> 24));
                this.write((byte)(l >> 26));
                this.write((byte)(l >> 8));
                this.write((byte)l);
            }
        }
    }

    public void writeObject(BCPGObject bCPGObject) throws IOException {
        bCPGObject.encode(this);
    }

    void writePacket(int n, byte[] byArray, boolean bl) throws IOException {
        this.writeHeader(n, bl, false, byArray.length);
        this.write(byArray);
    }

    public void writePacket(ContainedPacket containedPacket) throws IOException {
        containedPacket.encode(this);
    }
}

