/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;

public class PGPKeyPair
implements PublicKeyAlgorithmTags {
    private long keyID;
    private byte[] fingerPrint;
    PGPPublicKey pub;
    PrivateKey privKey;

    public PGPKeyPair(int n, PublicKey publicKey, PrivateKey privateKey, Date date, String string) throws PGPException, NoSuchProviderException {
        this.privKey = privateKey;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1", string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("can't find SHA1 digest");
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            PublicKeyPacket publicKeyPacket = new PublicKeyPacket(n, date, new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent()));
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            DSAParams dSAParams = dSAPublicKey.getParams();
            PublicKeyPacket publicKeyPacket = new PublicKeyPacket(n, date, new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY()));
        } else if (publicKey instanceof ElGamalPublicKey) {
            ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)publicKey;
            ElGamalParameterSpec elGamalParameterSpec = elGamalPublicKey.getParams();
            PublicKeyPacket publicKeyPacket = new PublicKeyPacket(n, date, new ElGamalPublicBCPGKey(elGamalParameterSpec.getP(), elGamalParameterSpec.getG(), elGamalPublicKey.getY()));
        } else {
            throw new PGPException("unknown key class");
        }
    }

    public PGPPrivateKey getPrivateKey() {
        return new PGPPrivateKey(this.privKey, this.pub.getKeyID());
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }
}

