package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Date;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketTags;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.TrustSignature;

/**
 * Generator for signature subpackets.
 */
public class PGPSignatureSubpacketGenerator
{
	ArrayList	list = new ArrayList();
	
	public PGPSignatureSubpacketGenerator()
	{
	}
	
	public void setRevocable(
		boolean	isCritical,
		boolean	isRevocable)
	{
		list.add(new Revocable(isCritical, isRevocable));
	}
	
	public void setExportable(
		boolean	isCritical,
		boolean	isExportable)
	{
		list.add(new Revocable(isCritical, isExportable));
	}
	
	public void setTrust(
		boolean	isCritical,
		int			depth,
		int			trustAmount)
	{
		list.add(new TrustSignature(isCritical, depth, trustAmount));
	}
	
	public void setKeyExpirationTime(
		boolean	isCritical,
		Date			expirationTime)
	{
		list.add(new KeyExpirationTime(isCritical, expirationTime));
	}
	
	public void setSignatureExpirationTime(
		boolean	isCritical,
		Date			expirationTime)
	{
		list.add(new SignatureExpirationTime(isCritical, expirationTime));
	}
	
	public void setPreferredHashAlgorithms(
		boolean	isCritical,
		int[]			algorithms)
	{
		list.add(new PreferredAlgorithms(SignatureSubpacketTags.PREFERRED_HASH_ALGS, isCritical, algorithms));
	}
	
	public void setPreferredSymmetricAlgorithms(
		boolean	isCritical,
		int[]			algorithms)
	{
		list.add(new PreferredAlgorithms(SignatureSubpacketTags.PREFERRED_SYM_ALGS, isCritical, algorithms));
	}
	
	public void setPreferredCompressionAlgorithms(
		boolean	isCritical,
		int[]			algorithms)
	{
		list.add(new PreferredAlgorithms(SignatureSubpacketTags.PREFERRED_COMP_ALGS, isCritical, algorithms));
	}
	
	public void setKeyFlags(
		boolean	isCritical,
		int			flags)
	{
		list.add(new KeyFlags(isCritical, flags));
	}
	
	public PGPSignatureSubpacketVector generate()
	{
		return new PGPSignatureSubpacketVector((SignatureSubpacket[])list.toArray(new SignatureSubpacket[list.size()]));
	}
}
