package org.bouncycastle.asn1.x509;

import java.math.BigInteger;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class BasicConstraints
    implements DEREncodable
{
    DERBoolean  cA = new DERBoolean(false);
    DERInteger  pathLenConstraint = null;

    public static BasicConstraints getInstance(
        ASN1TaggedObject obj,
        boolean          explicit)
    {
        return getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static BasicConstraints getInstance(
        Object  obj)
    {
        if (obj == null || obj instanceof BasicConstraints)
        {
            return (BasicConstraints)obj;
        }
        else if (obj instanceof ASN1Sequence)
        {
            return new BasicConstraints((ASN1Sequence)obj);
        }

        throw new IllegalArgumentException("unknown object in factory");
    }
	
    public BasicConstraints(
        ASN1Sequence   seq)
    {
        this.cA = (DERBoolean)seq.getObjectAt(0);
        if (seq.size() > 1)
        {
            this.pathLenConstraint = (DERInteger)seq.getObjectAt(1);
        }
    }

    public BasicConstraints(
        boolean cA,
        int     pathLenConstraint)
    {
        this.cA = new DERBoolean(cA);
        this.pathLenConstraint = new DERInteger(pathLenConstraint);
    }

    public BasicConstraints(
        boolean cA)
    {
        this.cA = new DERBoolean(cA);
        this.pathLenConstraint = null;
    }

    public boolean isCA()
    {
        return cA.isTrue();
    }

    public BigInteger getPathLenConstraint()
    {
        if (pathLenConstraint != null)
        {
            return pathLenConstraint.getValue();
        }

        return null;
    }

    /**
     * <pre>
     * BasicConstraints := SEQUENCE {
     *    cA                  BOOLEAN DEFAULT FALSE,
     *    pathLenConstraint   INTEGER (0..MAX) OPTIONAL
     * }
     * </pre>
     */
    public DERObject getDERObject()
    {
        ASN1EncodableVector  v = new ASN1EncodableVector();

        v.add(cA);

        if (pathLenConstraint != null)
        {
            v.add(pathLenConstraint);
        }

        return new DERSequence(v);
    }

    public String toString()
    {
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + pathLenConstraint.getValue();
    }
}
