/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CAST6Engine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.IDEAEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.engines.RC532Engine;
import org.bouncycastle.crypto.engines.RC564Engine;
import org.bouncycastle.crypto.engines.RC6Engine;
import org.bouncycastle.crypto.engines.RijndaelEngine;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.SkipjackEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.crypto.params.RC5Parameters;
import org.bouncycastle.jce.provider.JCEPBEKey;
import org.bouncycastle.jce.provider.PBE;
import org.bouncycastle.jce.provider.WrapCipherSpi;

public class JCEBlockCipher
extends WrapCipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{class$javax$crypto$spec$RC2ParameterSpec != null ? class$javax$crypto$spec$RC2ParameterSpec : (class$javax$crypto$spec$RC2ParameterSpec = JCEBlockCipher.class$("javax.crypto.spec.RC2ParameterSpec")), class$javax$crypto$spec$RC5ParameterSpec != null ? class$javax$crypto$spec$RC5ParameterSpec : (class$javax$crypto$spec$RC5ParameterSpec = JCEBlockCipher.class$("javax.crypto.spec.RC5ParameterSpec")), class$javax$crypto$spec$IvParameterSpec != null ? class$javax$crypto$spec$IvParameterSpec : (class$javax$crypto$spec$IvParameterSpec = JCEBlockCipher.class$("javax.crypto.spec.IvParameterSpec")), class$javax$crypto$spec$PBEParameterSpec != null ? class$javax$crypto$spec$PBEParameterSpec : (class$javax$crypto$spec$PBEParameterSpec = JCEBlockCipher.class$("javax.crypto.spec.PBEParameterSpec"))};
    private BlockCipher baseEngine;
    private BufferedBlockCipher cipher;
    private ParametersWithIV ivParam;
    private int pbeType = 2;
    private int pbeHash = 1;
    private int pbeKeySize;
    private int pbeIvSize;
    private int ivLength = 0;
    private AlgorithmParameters engineParams = null;
    private boolean padded = true;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC5ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    protected JCEBlockCipher(BlockCipher blockCipher) {
        this.baseEngine = blockCipher;
        this.cipher = new PaddedBufferedBlockCipher(blockCipher);
    }

    protected JCEBlockCipher(BlockCipher blockCipher, int n) {
        this.baseEngine = blockCipher;
        this.cipher = new PaddedBufferedBlockCipher(blockCipher);
        this.ivLength = n / 8;
    }

    protected JCEBlockCipher(BlockCipher blockCipher, int n, int n2, int n3, int n4) {
        this.baseEngine = blockCipher;
        this.cipher = new PaddedBufferedBlockCipher(blockCipher);
        this.pbeType = n;
        this.pbeHash = n2;
        this.pbeKeySize = n3;
        this.pbeIvSize = n4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3 = 0;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        if (n2 != 0) {
            n3 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
        }
        try {
            n3 += this.cipher.doFinal(byArray2, n3);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        int n4 = 0;
        if (n2 != 0) {
            n4 = this.cipher.processBytes(byArray, n, n2, byArray2, n3);
        }
        try {
            return n4 + this.cipher.doFinal(byArray2, n3 + n4);
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalBlockSizeException(dataLengthException.getMessage());
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new BadPaddingException(invalidCipherTextException.getMessage());
        }
    }

    protected int engineGetBlockSize() {
        return this.baseEngine.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.ivParam != null) {
            String string = this.cipher.getUnderlyingCipher().getAlgorithmName();
            if (string.indexOf(47) >= 0) {
                string = string.substring(0, string.indexOf(47));
            }
            try {
                this.engineParams = AlgorithmParameters.getInstance(string, "BC");
                this.engineParams.init(this.ivParam.getIV());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            int n2 = 0;
            while (n2 != this.availableSpecs.length) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[n2]);
                    break;
                }
                catch (Exception exception) {
                    ++n2;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        CipherParameters cipherParameters;
        if (algorithmParameterSpec == null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (key instanceof JCEPBEKey) {
            cipherParameters = PBE.Util.makePBEParameters((JCEPBEKey)key, algorithmParameterSpec, this.pbeType, this.pbeHash, this.cipher.getUnderlyingCipher().getAlgorithmName(), this.pbeKeySize, this.pbeIvSize);
            if (this.pbeIvSize != 0) {
                this.ivParam = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec == null) {
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                object = (IvParameterSpec)algorithmParameterSpec;
                if (((IvParameterSpec)object).getIV().length != this.ivLength) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                cipherParameters = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)object).getIV());
                this.ivParam = (ParametersWithIV)cipherParameters;
            } else {
                cipherParameters = new KeyParameter(key.getEncoded());
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            object = (RC2ParameterSpec)algorithmParameterSpec;
            cipherParameters = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
            if (((RC2ParameterSpec)object).getIV() != null && this.ivLength != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, ((RC2ParameterSpec)object).getIV());
                this.ivParam = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            object = (RC5ParameterSpec)algorithmParameterSpec;
            cipherParameters = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)algorithmParameterSpec).getRounds());
            if (this.baseEngine.getAlgorithmName().startsWith("RC5")) {
                if (this.baseEngine.getAlgorithmName().equals("RC5-32")) {
                    if (((RC5ParameterSpec)object).getWordSize() != 32) {
                        throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + ((RC5ParameterSpec)object).getWordSize() + ".");
                    }
                } else if (this.baseEngine.getAlgorithmName().equals("RC5-64") && ((RC5ParameterSpec)object).getWordSize() != 64) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + ((RC5ParameterSpec)object).getWordSize() + ".");
                }
            } else {
                throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            }
            if (((RC5ParameterSpec)object).getIV() != null && this.ivLength != 0) {
                cipherParameters = new ParametersWithIV(cipherParameters, ((RC5ParameterSpec)object).getIV());
                this.ivParam = (ParametersWithIV)cipherParameters;
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(cipherParameters instanceof ParametersWithIV)) {
            object = secureRandom;
            if (object == null) {
                object = new SecureRandom();
            }
            if (n == 1 || n == 3) {
                byte[] byArray = new byte[this.ivLength];
                ((SecureRandom)object).nextBytes(byArray);
                cipherParameters = new ParametersWithIV(cipherParameters, byArray);
                this.ivParam = (ParametersWithIV)cipherParameters;
            } else if (this.cipher.getUnderlyingCipher().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (secureRandom != null && this.padded) {
            cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
        }
        switch (n) {
            case 1: 
            case 3: {
                this.cipher.init(true, cipherParameters);
                break;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, cipherParameters);
                break;
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineSetMode(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher());
        } else if (string2.equals("CBC")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(this.cipher.getUnderlyingCipher()));
        } else if (string2.startsWith("OFB")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            if (string2.length() != 3) {
                int n = Integer.parseInt(string2.substring(3));
                this.cipher = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.cipher.getUnderlyingCipher(), n));
            } else {
                this.cipher = new PaddedBufferedBlockCipher(new OFBBlockCipher(this.cipher.getUnderlyingCipher(), 8 * this.cipher.getBlockSize()));
            }
        } else if (string2.startsWith("CFB")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            if (string2.length() != 3) {
                int n = Integer.parseInt(string2.substring(3));
                this.cipher = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.cipher.getUnderlyingCipher(), n));
            } else {
                this.cipher = new PaddedBufferedBlockCipher(new CFBBlockCipher(this.cipher.getUnderlyingCipher(), 8 * this.cipher.getBlockSize()));
            }
        } else if (string2.startsWith("PGP")) {
            if (string2.equalsIgnoreCase("PGPCFBwithIV")) {
                this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
                this.cipher = new PaddedBufferedBlockCipher(new PGPCFBBlockCipher(this.cipher.getUnderlyingCipher(), true));
            } else {
                this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
                this.cipher = new PaddedBufferedBlockCipher(new PGPCFBBlockCipher(this.cipher.getUnderlyingCipher(), false));
            }
        } else if (string2.startsWith("SIC")) {
            this.ivLength = this.cipher.getUnderlyingCipher().getBlockSize();
            if (this.ivLength < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.cipher = new PaddedBufferedBlockCipher(new SICBlockCipher(this.cipher.getUnderlyingCipher()));
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = string.toUpperCase();
        if (string2.equals("NOPADDING")) {
            this.padded = false;
            this.cipher = new BufferedBlockCipher(this.cipher.getUnderlyingCipher());
        } else if (string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING")) {
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher());
        } else if (string2.equals("ISO10126PADDING") || string2.equals("ISO10126-2PADDING")) {
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher(), new ISO10126d2Padding());
        } else if (string2.equals("X9.23PADDING") || string2.equals("X923PADDING")) {
            this.cipher = new PaddedBufferedBlockCipher(this.cipher.getUnderlyingCipher(), new X923Padding());
        } else if (string2.equals("WITHCTS")) {
            this.padded = false;
            this.cipher = new CTSBlockCipher(this.cipher.getUnderlyingCipher());
        } else {
            throw new NoSuchPaddingException("Padding " + string + " unknown.");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3 = this.cipher.getUpdateOutputSize(n2);
        if (n3 > 0) {
            byte[] byArray2 = new byte[n3];
            int n4 = this.cipher.processBytes(byArray, n, n2, byArray2, 0);
            if (n4 == 0) {
                return null;
            }
            if (n4 != byArray2.length) {
                byte[] byArray3 = new byte[n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n4);
                return byArray3;
            }
            return byArray2;
        }
        this.cipher.processBytes(byArray, n, n2, null, 0);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.cipher.processBytes(byArray, n, n2, byArray2, n3);
    }

    public static class DES
    extends JCEBlockCipher {
        public DES() {
            super(new DESEngine());
        }
    }

    public static class DESCBC
    extends JCEBlockCipher {
        public DESCBC() {
            super(new CBCBlockCipher(new DESEngine()), 64);
        }
    }

    public static class DESede
    extends JCEBlockCipher {
        public DESede() {
            super(new DESedeEngine());
        }
    }

    public static class DESedeCBC
    extends JCEBlockCipher {
        public DESedeCBC() {
            super(new CBCBlockCipher(new DESedeEngine()), 64);
        }
    }

    public static class Skipjack
    extends JCEBlockCipher {
        public Skipjack() {
            super(new SkipjackEngine());
        }
    }

    public static class Blowfish
    extends JCEBlockCipher {
        public Blowfish() {
            super(new BlowfishEngine());
        }
    }

    public static class Twofish
    extends JCEBlockCipher {
        public Twofish() {
            super(new TwofishEngine());
        }
    }

    public static class RC2
    extends JCEBlockCipher {
        public RC2() {
            super(new RC2Engine());
        }
    }

    public static class RC2CBC
    extends JCEBlockCipher {
        public RC2CBC() {
            super(new CBCBlockCipher(new RC2Engine()), 64);
        }
    }

    public static class RC5
    extends JCEBlockCipher {
        public RC5() {
            super(new RC532Engine());
        }
    }

    public static class RC564
    extends JCEBlockCipher {
        public RC564() {
            super(new RC564Engine());
        }
    }

    public static class RC6
    extends JCEBlockCipher {
        public RC6() {
            super(new RC6Engine());
        }
    }

    public static class AES
    extends JCEBlockCipher {
        public AES() {
            super(new AESFastEngine());
        }
    }

    public static class AESCBC
    extends JCEBlockCipher {
        public AESCBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class Rijndael
    extends JCEBlockCipher {
        public Rijndael() {
            super(new RijndaelEngine());
        }
    }

    public static class Serpent
    extends JCEBlockCipher {
        public Serpent() {
            super(new SerpentEngine());
        }
    }

    public static class CAST5
    extends JCEBlockCipher {
        public CAST5() {
            super(new CAST5Engine());
        }
    }

    public static class CAST5CBC
    extends JCEBlockCipher {
        public CAST5CBC() {
            super(new CBCBlockCipher(new CAST5Engine()), 64);
        }
    }

    public static class CAST6
    extends JCEBlockCipher {
        public CAST6() {
            super(new CAST6Engine());
        }
    }

    public static class IDEA
    extends JCEBlockCipher {
        public IDEA() {
            super(new IDEAEngine());
        }
    }

    public static class IDEACBC
    extends JCEBlockCipher {
        public IDEACBC() {
            super(new CBCBlockCipher(new IDEAEngine()), 64);
        }
    }

    public static class PBEWithMD5AndDES
    extends JCEBlockCipher {
        public PBEWithMD5AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 0, 64, 64);
        }
    }

    public static class PBEWithMD5AndRC2
    extends JCEBlockCipher {
        public PBEWithMD5AndRC2() {
            super(new CBCBlockCipher(new RC2Engine()), 0, 0, 128, 64);
        }
    }

    public static class PBEWithSHA1AndDES
    extends JCEBlockCipher {
        public PBEWithSHA1AndDES() {
            super(new CBCBlockCipher(new DESEngine()), 0, 1, 64, 64);
        }
    }

    public static class PBEWithSHA1AndRC2
    extends JCEBlockCipher {
        public PBEWithSHA1AndRC2() {
            super(new CBCBlockCipher(new RC2Engine()), 0, 1, 128, 64);
        }
    }

    public static class PBEWithSHAAndDES3Key
    extends JCEBlockCipher {
        public PBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 192, 64);
        }
    }

    public static class PBEWithSHAAndDES2Key
    extends JCEBlockCipher {
        public PBEWithSHAAndDES2Key() {
            super(new CBCBlockCipher(new DESedeEngine()), 2, 1, 128, 64);
        }
    }

    public static class PBEWithSHAAnd128BitRC2
    extends JCEBlockCipher {
        public PBEWithSHAAnd128BitRC2() {
            super(new CBCBlockCipher(new RC2Engine()), 2, 1, 128, 64);
        }
    }

    public static class PBEWithSHAAnd40BitRC2
    extends JCEBlockCipher {
        public PBEWithSHAAnd40BitRC2() {
            super(new CBCBlockCipher(new RC2Engine()), 2, 1, 40, 64);
        }
    }

    public static class PBEWithSHAAndTwofish
    extends JCEBlockCipher {
        public PBEWithSHAAndTwofish() {
            super(new CBCBlockCipher(new TwofishEngine()), 2, 1, 256, 128);
        }
    }

    public static class PBEWithSHAAndIDEA
    extends JCEBlockCipher {
        public PBEWithSHAAndIDEA() {
            super(new CBCBlockCipher(new IDEAEngine()), 2, 1, 128, 64);
        }
    }
}

