/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.sql.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;

public class PGPUtil {
    private static String defProvider = "BC";

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName");
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature.");
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    static String getSymmetricCipherName(int n) throws PGPException {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DES_EDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new PGPException("unknown symmetric algorithm: " + n);
    }

    public static SecretKey makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return new SecretKeySpec(byArray, string);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, char[] cArray, String string) throws NoSuchProviderException, PGPException {
        return PGPUtil.makeKeyFromPassPhrase(n, null, cArray, string);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, S2K s2K, char[] cArray, String string) throws PGPException, NoSuchProviderException {
        MessageDigest messageDigest;
        byte[] byArray;
        int n2;
        String string2;
        block32: {
            block31: {
                string2 = null;
                n2 = 0;
                switch (n) {
                    case 2: {
                        n2 = 192;
                        string2 = "DES_EDE";
                        break;
                    }
                    case 1: {
                        n2 = 128;
                        string2 = "IDEA";
                        break;
                    }
                    case 3: {
                        n2 = 128;
                        string2 = "CAST5";
                        break;
                    }
                    case 4: {
                        n2 = 128;
                        string2 = "Blowfish";
                        break;
                    }
                    case 5: {
                        n2 = 128;
                        string2 = "SAFER";
                        break;
                    }
                    case 6: {
                        n2 = 64;
                        string2 = "DES";
                        break;
                    }
                    case 7: {
                        n2 = 128;
                        string2 = "AES";
                        break;
                    }
                    case 8: {
                        n2 = 192;
                        string2 = "AES";
                        break;
                    }
                    case 9: {
                        n2 = 256;
                        string2 = "AES";
                        break;
                    }
                    case 10: {
                        n2 = 256;
                        string2 = "Twofish";
                        break;
                    }
                    default: {
                        throw new PGPException("unknown symmetric algorithm: " + n);
                    }
                }
                byArray = new byte[cArray.length];
                int n3 = 0;
                while (n3 != cArray.length) {
                    byArray[n3] = (byte)cArray[n3];
                    ++n3;
                }
                if (s2K == null) break block31;
                try {
                    switch (s2K.getHashAlgorithm()) {
                        case 2: {
                            messageDigest = MessageDigest.getInstance("SHA1", string);
                            break;
                        }
                        default: {
                            throw new PGPException("unknown hash algorithm: " + s2K.getHashAlgorithm());
                        }
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new PGPException("can't find MD5 digest", noSuchAlgorithmException);
                }
                byte[] byArray2 = s2K.getIV();
                switch (s2K.getType()) {
                    case 0: {
                        messageDigest.update(byArray);
                        break block32;
                    }
                    case 1: {
                        messageDigest.update(byArray2);
                        messageDigest.update(byArray);
                        break block32;
                    }
                    case 3: {
                        long l = s2K.getIterationCount();
                        messageDigest.update(byArray2);
                        messageDigest.update(byArray);
                        l -= (long)(byArray2.length + cArray.length);
                        while (l > 0L) {
                            if (l < (long)byArray2.length) {
                                messageDigest.update(byArray2, 0, (int)l);
                                l = 0L;
                            } else {
                                messageDigest.update(byArray2);
                            }
                            if (l < (long)byArray.length) {
                                messageDigest.update(byArray, 0, (int)l);
                            } else {
                                messageDigest.update(byArray);
                            }
                            l -= (long)(byArray2.length + cArray.length);
                        }
                        break block32;
                    }
                    default: {
                        throw new PGPException("unknown S2K type: " + s2K.getType());
                    }
                }
            }
            try {
                messageDigest = MessageDigest.getInstance("MD5", string);
                messageDigest.update(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PGPException("can't find MD5 digest", noSuchAlgorithmException);
            }
        }
        int n4 = 0;
        while (n4 != byArray.length) {
            byArray[n4] = 0;
            ++n4;
        }
        byte[] byArray3 = messageDigest.digest();
        byte[] byArray4 = new byte[(n2 + 7) / 8];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return new SecretKeySpec(byArray4, string2);
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file) throws IOException {
        int n;
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), file.length(), new Date(file.lastModified()));
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) > 0) {
            outputStream2.write(byArray, 0, n);
        }
        pGPLiteralDataGenerator.close();
    }
}

