/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERGeneralizedTime
extends DERObject {
    String time;

    public DERGeneralizedTime(String string) {
        this.time = string;
    }

    public DERGeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = simpleDateFormat.format(date);
    }

    DERGeneralizedTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[n] & 0xFF);
            ++n;
        }
        this.time = new String(cArray);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(24, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)object).time);
    }

    public static DERGeneralizedTime getInstance(Object object) {
        if (object == null || object instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERGeneralizedTime.getInstance(aSN1TaggedObject.getObject());
    }

    private byte[] getOctets() {
        char[] cArray = this.time.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n != cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public String getTime() {
        if (this.time.length() == 15) {
            return String.valueOf(this.time.substring(0, 14)) + "GMT+00:00";
        }
        if (this.time.length() == 17) {
            return String.valueOf(this.time.substring(0, 14)) + "GMT" + this.time.substring(15, 17) + ":" + this.time.substring(17, 19);
        }
        return this.time;
    }
}

