/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertStoreSpi;
import org.bouncycastle.jce.cert.CertUtil;

public class CertStore {
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;
    static /* synthetic */ Class class$org$bouncycastle$jce$cert$CertStoreParameters;

    protected CertStore(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
        this.storeSpi = certStoreSpi;
        this.provider = provider;
        this.type = string;
        this.params = certStoreParameters;
    }

    public final Collection getCertificates(CertSelector certSelector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(certSelector);
    }

    public final Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(cRLSelector);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        try {
            CertUtil.Implementation implementation = CertUtil.getImplementation("CertStore", string, (String)null, new Class[]{class$org$bouncycastle$jce$cert$CertStoreParameters == null ? (class$org$bouncycastle$jce$cert$CertStoreParameters = CertStore.class$("org.bouncycastle.jce.cert.CertStoreParameters")) : class$org$bouncycastle$jce$cert$CertStoreParameters}, new Object[]{certStoreParameters});
            if (implementation != null) {
                return new CertStore((CertStoreSpi)implementation.getEngine(), implementation.getProvider(), string, certStoreParameters);
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, String string2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertStore", string, string2, new Class[]{class$org$bouncycastle$jce$cert$CertStoreParameters == null ? (class$org$bouncycastle$jce$cert$CertStoreParameters = CertStore.class$("org.bouncycastle.jce.cert.CertStoreParameters")) : class$org$bouncycastle$jce$cert$CertStoreParameters}, new Object[]{certStoreParameters});
        if (implementation != null) {
            return new CertStore((CertStoreSpi)implementation.getEngine(), implementation.getProvider(), string, certStoreParameters);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, IllegalArgumentException {
        if (provider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertStore", string, provider, new Class[]{class$org$bouncycastle$jce$cert$CertStoreParameters == null ? (class$org$bouncycastle$jce$cert$CertStoreParameters = CertStore.class$("org.bouncycastle.jce.cert.CertStoreParameters")) : class$org$bouncycastle$jce$cert$CertStoreParameters}, new Object[]{certStoreParameters});
        if (implementation != null) {
            return new CertStore((CertStoreSpi)implementation.getEngine(), provider, string, certStoreParameters);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public final CertStoreParameters getCertStoreParameters() {
        return this.params;
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public static final String getDefaultType() {
        String string = null;
        string = Security.getProperty("certstore.type");
        if (string == null || string.length() <= 0) {
            return "LDAP";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

