/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.MimeBodyPart;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;

public class SignedDataTest
extends TestCase {
    boolean DEBUG = true;
    MimeBodyPart msg;
    String signDN;
    KeyPair signKP;
    X509Certificate signCert;
    String origDN;
    KeyPair origKP;
    X509Certificate origCert;
    String reciDN;
    KeyPair reciKP;
    X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;
    static /* synthetic */ Class class$org$bouncycastle$cms$test$SignedDataTest;

    public SignedDataTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Class)(class$org$bouncycastle$cms$test$SignedDataTest == null ? (class$org$bouncycastle$cms$test$SignedDataTest = SignedDataTest.class$("org.bouncycastle.cms.test.SignedDataTest")) : class$org$bouncycastle$cms$test$SignedDataTest));
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$cms$test$SignedDataTest == null ? (class$org$bouncycastle$cms$test$SignedDataTest = SignedDataTest.class$("org.bouncycastle.cms.test.SignedDataTest")) : class$org$bouncycastle$cms$test$SignedDataTest);
    }

    public void log(Exception exception) {
        if (this.DEBUG) {
            exception.printStackTrace();
        }
    }

    public void log(String string) {
        if (this.DEBUG) {
            System.out.println(string);
        }
    }

    public void setUp() {
        try {
            this.signDN = "O=Bouncy Castle, C=AU";
            this.signKP = CMSTestUtil.makeKeyPair();
            this.signCert = CMSTestUtil.makeCertificate(this.signKP, this.signDN, this.signKP, this.signDN);
            this.origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            this.origKP = CMSTestUtil.makeKeyPair();
            this.origCert = CMSTestUtil.makeCertificate(this.origKP, this.origDN, this.signKP, this.signDN);
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    public void tearDown() {
    }

    public void testSHA1WithRSAEncapsulated() {
        try {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray("Hello World!".getBytes());
            arrayList.add(this.origCert);
            arrayList.add(this.signCert);
            CertStore certStore = CertStore.getInstance((String)"Collection", (CertStoreParameters)new CollectionCertStoreParameters(arrayList), (String)"BC");
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSigner(this.origKP.getPrivate(), this.origCert, "1.3.14.3.2.26");
            cMSSignedDataGenerator.addCertificatesAndCRLs(certStore);
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true, "BC");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cMSSignedData.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            cMSSignedData = new CMSSignedData(ContentInfo.getInstance((Object)aSN1InputStream.readObject()));
            certStore = cMSSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection collection = signerInformationStore.getSigners();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SignerInformation signerInformation = (SignerInformation)iterator.next();
                Collection collection2 = certStore.getCertificates((CertSelector)signerInformation.getSID());
                Iterator iterator2 = collection2.iterator();
                X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                Assert.assertEquals((boolean)true, (boolean)signerInformation.verify(x509Certificate, "BC"));
            }
        }
        catch (Exception exception) {
            this.log(exception);
            Assert.fail();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

