/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.PacketTags;

public class PGPLiteralDataGenerator
implements CompressionAlgorithmTags,
PacketTags {
    private BCPGOutputStream pkOut;

    public OutputStream open(OutputStream outputStream, char c, String string, long l, Date date) throws IOException {
        this.pkOut = new BCPGOutputStream(outputStream, 11, l + 2L + (long)string.length() + 4L);
        this.pkOut.write(c);
        this.pkOut.write((byte)string.length());
        int n = 0;
        while (n != string.length()) {
            this.pkOut.write(string.charAt(n));
            ++n;
        }
        long l2 = date.getTime() / 1000L;
        this.pkOut.write((byte)(l2 >> 24));
        this.pkOut.write((byte)(l2 >> 16));
        this.pkOut.write((byte)(l2 >> 8));
        this.pkOut.write((byte)l2);
        return this.pkOut;
    }

    public OutputStream open(OutputStream outputStream, char c, File file) throws IOException {
        String string = file.getName();
        this.pkOut = new BCPGOutputStream(outputStream, 11, file.length() + 2L + (long)string.length() + 4L);
        this.pkOut.write(c);
        this.pkOut.write((byte)string.length());
        int n = 0;
        while (n != string.length()) {
            this.pkOut.write(string.charAt(n));
            ++n;
        }
        long l = file.lastModified() / 1000L;
        this.pkOut.write((byte)(l >> 24));
        this.pkOut.write((byte)(l >> 16));
        this.pkOut.write((byte)(l >> 8));
        this.pkOut.write((byte)l);
        return this.pkOut;
    }

    public void close() throws IOException {
        this.pkOut.flush();
    }
}

