/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PGPDSATest
implements Test {
    byte[] testPubKey = Base64.decode((String)"mQGiBD9HBzURBACzkxRCVGJg5+Ld9DU4Xpnd4LCKgMq7YOY7Gi0EgK92gbaa6+zQoQFqz1tt3QUmpz3YVkm/zLESBBtC1ACIXGggUdFMUr5I87+1Cb6vzefAtGt8N5VV1F/MXv1gJz4Bu6HyxL/ncfe71jsNhav0i4yAjf2etWFj53zK6R+Ojg5H6wCgpL9/tXVfGP8SqFvyrN/437MlFSUEAIN3V6j/MUllyrZglrtr2+RWIwRrG/ACmrF6hTugOl4cQxaDYNcntXbhlTlJs9MxjTH3xxzylyirCyq7HzGJxZzSt6FTeh1DFYzhJ7QuYR1xrSdA6Y0mUv0ixD5A4nPHjupQ5QCqHGeRfFD/oHzD4zqBnJp/BJ3LvQ66bERJmKl5A/4uj3HoVxpb0vvyENfRqKMmGBISycY4MoH5uWfb23FffsT9r9KL6nJ4syLzaRR0gvcbcjkc9Z3epI7gr3jTrb4d8WPxsDbT/W1tv9bG/EHawomLcihtuUU68Uej6/wZot1XJqu2nQlku57+M/V2X1y26VKsipolPfja4uyBOOyvbLQzRXJpYyBFY2hpZG5hIChEU0EgVGVzdCBLZXkpIDxlcmljQGJvdW5jeWNhc3RsZS5vcmc+iFkEExECABkFAj9HBzUECwcDAgMVAgMDFgIBAh4BAheAAAoJEM0j9enEyjRDAlwAn2rrom0sMhufWK5vIRwg7gj5qsLEAJ4vnT5dPBVblofsG+pDoCVeJXGGng==");
    byte[] testPrivKey = Base64.decode((String)"lQHhBD9HBzURBACzkxRCVGJg5+Ld9DU4Xpnd4LCKgMq7YOY7Gi0EgK92gbaa6+zQoQFqz1tt3QUmpz3YVkm/zLESBBtC1ACIXGggUdFMUr5I87+1Cb6vzefAtGt8N5VV1F/MXv1gJz4Bu6HyxL/ncfe71jsNhav0i4yAjf2etWFj53zK6R+Ojg5H6wCgpL9/tXVfGP8SqFvyrN/437MlFSUEAIN3V6j/MUllyrZglrtr2+RWIwRrG/ACmrF6hTugOl4cQxaDYNcntXbhlTlJs9MxjTH3xxzylyirCyq7HzGJxZzSt6FTeh1DFYzhJ7QuYR1xrSdA6Y0mUv0ixD5A4nPHjupQ5QCqHGeRfFD/oHzD4zqBnJp/BJ3LvQ66bERJmKl5A/4uj3HoVxpb0vvyENfRqKMmGBISycY4MoH5uWfb23FffsT9r9KL6nJ4syLzaRR0gvcbcjkc9Z3epI7gr3jTrb4d8WPxsDbT/W1tv9bG/EHawomLcihtuUU68Uej6/wZot1XJqu2nQlku57+M/V2X1y26VKsipolPfja4uyBOOyvbP4DAwIDIBTxWjkCGGAWQO2jy9CTvLHJEoTO7moHrp1FxOVpQ8iJHyRqZzLllO26OzgohbiPYz8u9qCulZ9Xn7QzRXJpYyBFY2hpZG5hIChEU0EgVGVzdCBLZXkpIDxlcmljQGJvdW5jeWNhc3RsZS5vcmc+iFkEExECABkFAj9HBzUECwcDAgMVAgMDFgIBAh4BAheAAAoJEM0j9enEyjRDAlwAnjTjjt57NKIgyym7OTCwzIU3xgFpAJ0VO5m5PfQKmGJRhaewLSZD4nXkHg==");
    byte[] sig1 = Base64.decode((String)"owGbwMvMwCR4VvnryyOnTJwZ10gncZSkFpfolVSU2Ltz78hIzcnJVyjPL8pJUeTqsGdmZQCJwpQLMq3ayTA/0Fj3xf4jbwPfK/H3zj55Z9L1n2k/GOapKJrvMZ4tLiCWGtP/XeDqX4fORDUA");
    byte[] sig1crc = Base64.decode((String)"=OZa/");
    char[] pass = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};

    public TestResult perform() {
        try {
            int n;
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "BC");
            PGPPublicKey pGPPublicKey = null;
            Object var3_4 = null;
            PGPUtil.setDefaultProvider("BC");
            PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey);
            pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKey);
            PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(this.pass, "BC");
            PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(this.sig1);
            PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
            pGPObjectFactory = new PGPObjectFactory(pGPCompressedData.getDataStream());
            PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)pGPObjectFactory.nextObject();
            PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
            PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory.nextObject();
            InputStream inputStream = pGPLiteralData.getInputStream();
            pGPOnePassSignature.initVerify(pGPPublicKey, "BC");
            while ((n = inputStream.read()) >= 0) {
                pGPOnePassSignature.update((byte)n);
            }
            PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
            if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
                return new SimpleTestResult(false, this.getName() + ": Failed signature check");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + exception.toString());
        }
    }

    public String getName() {
        return "PGPDSATest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPDSATest pGPDSATest = new PGPDSATest();
        TestResult testResult = pGPDSATest.perform();
        System.out.println(testResult.toString());
    }
}

