/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedPrivateKeyInfo {
    private org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo infoObj;
    private AlgorithmParameters algP;

    public EncryptedPrivateKeyInfo(String string, byte[] byArray) throws NullPointerException, IllegalArgumentException, NoSuchAlgorithmException {
        if (string == null || byArray == null) {
            throw new NullPointerException("parameters null");
        }
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), null);
        this.infoObj = new org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])byArray.clone());
        this.algP = this.getParameters();
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters algorithmParameters, byte[] byArray) throws NullPointerException, IllegalArgumentException, NoSuchAlgorithmException {
        if (algorithmParameters == null || byArray == null) {
            throw new NullPointerException("parameters null");
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(algorithmParameters.getEncoded());
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(algorithmParameters.getAlgorithm()), dERInputStream.readObject());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error in encoding: " + iOException.toString());
        }
        this.infoObj = new org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])byArray.clone());
        this.algP = this.getParameters();
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws NullPointerException, IOException {
        if (byArray == null) {
            throw new NullPointerException("parameters null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        this.infoObj = new org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo((ASN1Sequence)dERInputStream.readObject());
        try {
            this.algP = this.getParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("can't create parameters: " + noSuchAlgorithmException.toString());
        }
    }

    public String getAlgName() {
        return this.infoObj.getEncryptionAlgorithm().getObjectId().getId();
    }

    public AlgorithmParameters getAlgParameters() {
        return this.algP;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(this.infoObj);
        dEROutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncryptedData() {
        return this.infoObj.getEncryptedData();
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            return new PKCS8EncodedKeySpec(cipher.doFinal(this.getEncryptedData()));
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("can't get keySpec: " + exception.toString());
        }
    }

    private AlgorithmParameters getParameters() throws NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getAlgName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.infoObj.getEncryptionAlgorithm().getParameters());
            dEROutputStream.close();
            algorithmParameters.init(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("unable to parse parameters");
        }
        return algorithmParameters;
    }
}

