/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.misc;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class CAST5CBCParameters
implements DEREncodable {
    DERInteger keyLength;
    ASN1OctetString iv;

    public CAST5CBCParameters(ASN1Sequence aSN1Sequence) {
        this.iv = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        this.keyLength = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public CAST5CBCParameters(byte[] byArray, int n) {
        this.iv = new DEROctetString(byArray);
        this.keyLength = new DERInteger(n);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.iv);
        aSN1EncodableVector.add(this.keyLength);
        return new DERSequence(aSN1EncodableVector);
    }

    public byte[] getIV() {
        return this.iv.getOctets();
    }

    public static CAST5CBCParameters getInstance(Object object) {
        if (object instanceof CAST5CBCParameters) {
            return (CAST5CBCParameters)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CAST5CBCParameters((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in CAST5CBCParameter factory");
    }

    public int getKeyLength() {
        return this.keyLength.getValue().intValue();
    }
}

