/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertificateFactory;

public class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private List certificates;

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        certPathEncodings = Collections.unmodifiableList(arrayList);
    }

    PKIXCertPath(InputStream inputStream, String string) throws CertificateException {
        block6: {
            super("X.509");
            try {
                if (string.equals("PkiPath")) {
                    DERInputStream dERInputStream = new DERInputStream(inputStream);
                    DERObject dERObject = dERInputStream.readObject();
                    if (dERObject == null || !(dERObject instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    while (enumeration.hasMoreElements()) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                        dEROutputStream.writeObject((DERObject)enumeration.nextElement());
                        dEROutputStream.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        this.certificates.add(0, certificateFactory.generateCertificate(byteArrayInputStream));
                    }
                    break block6;
                }
                throw new CertificateException("unsupported encoding");
            }
            catch (IOException iOException) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + iOException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + noSuchProviderException.toString());
            }
        }
    }

    PKIXCertPath(List list) {
        super("X.509");
        this.certificates = new ArrayList(list);
    }

    public List getCertificates() {
        return new ArrayList(this.certificates);
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Object e;
        Iterator iterator = this.getEncodings();
        if (iterator.hasNext() && (e = iterator.next()) instanceof String) {
            return this.getEncoded((String)e);
        }
        return null;
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        Object object;
        Object object2;
        DERSequence dERSequence = null;
        if (string.equals("PkiPath")) {
            object2 = new ASN1EncodableVector();
            object = this.certificates.listIterator(this.certificates.size());
            while (object.hasPrevious()) {
                ((DEREncodableVector)object2).add(this.getEncodedX509Certificate((X509Certificate)object.previous()));
            }
        } else {
            throw new CertificateEncodingException("unsupported encoding");
        }
        dERSequence = new DERSequence((DEREncodableVector)object2);
        if (dERSequence == null) {
            return null;
        }
        object2 = new ByteArrayOutputStream();
        object = new DEROutputStream((OutputStream)object2);
        try {
            ((DEROutputStream)object).writeObject(dERSequence);
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("IOExeption thrown: " + iOException.toString());
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    private DERObject getEncodedX509Certificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getEncoded());
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            return dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("IOException caught while encoding certificate\n" + iOException.toString());
        }
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }
}

