/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.CompressionAlgorithmTags;
import org.bouncycastle.bcpg.PacketTags;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags,
PacketTags {
    private int algorithm;
    private DeflaterOutputStream dOut;
    private BCPGOutputStream pkOut;
    private BCPGOutputStream pOut;

    public PGPCompressedDataGenerator(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("unknown compression algorithm");
        }
        this.algorithm = n;
    }

    public void close() throws IOException {
        if (this.dOut == null) {
            throw new IOException("generator not opened.");
        }
        this.pkOut.flush();
        this.dOut.finish();
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        if (this.algorithm == 1) {
            this.pkOut = new BCPGOutputStream(outputStream, 8);
            this.pkOut.write(1);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(-1, true));
        } else {
            this.pkOut = new BCPGOutputStream(outputStream, 8);
            this.pkOut.write(2);
            this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(-1));
        }
        return this.dOut;
    }
}

