/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;

public class SignedFileProcessor {
    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[2]) + ".asc");
                SignedFileProcessor.signFile(stringArray[2], fileInputStream, fileOutputStream, stringArray[4].toCharArray(), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(stringArray[1]) + ".bpg");
                SignedFileProcessor.signFile(stringArray[1], fileInputStream, fileOutputStream, stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileInputStream fileInputStream2 = new FileInputStream(stringArray[3]);
                SignedFileProcessor.verifyFile(fileInputStream, fileInputStream2, true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                FileInputStream fileInputStream3 = new FileInputStream(stringArray[2]);
                SignedFileProcessor.verifyFile(fileInputStream, fileInputStream3, false);
            }
        } else {
            System.err.println("usage: SignedFileProcessor -v|-s [-a] file keyfile [passPhrase]");
        }
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(new BCPGInputStream(inputStream));
        PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(1, 2, "BC");
        pGPSignatureGenerator.initSign(0, pGPPrivateKey);
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(pGPCompressedDataGenerator.open(outputStream));
        pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream);
        File file = new File(string);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(bCPGOutputStream, 'b', file);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        while ((n = fileInputStream.read()) >= 0) {
            outputStream2.write(n);
            pGPSignatureGenerator.update((byte)n);
        }
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        pGPLiteralDataGenerator.close();
        pGPCompressedDataGenerator.close();
        outputStream.close();
    }

    private static void verifyFile(InputStream inputStream, InputStream inputStream2, boolean bl) throws Exception {
        int n;
        if (bl) {
            inputStream = new ArmoredInputStream(inputStream);
        }
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        pGPObjectFactory = new PGPObjectFactory(pGPCompressedData.getDataStream());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)pGPObjectFactory.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory.nextObject();
        InputStream inputStream3 = pGPLiteralData.getInputStream();
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(new BCPGInputStream(inputStream2));
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        FileOutputStream fileOutputStream = new FileOutputStream(pGPLiteralData.getFileName());
        pGPOnePassSignature.initVerify(pGPPublicKey, "BC");
        while ((n = inputStream3.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
            fileOutputStream.write(n);
        }
        fileOutputStream.close();
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        if (pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }
}

