/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;

    private static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
            return ContentInfo.getInstance((Object)aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
    }

    public CMSEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSEnvelopedData.readContentInfo(new ByteArrayInputStream(byArray)));
    }

    public CMSEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSEnvelopedData.readContentInfo(inputStream));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        EnvelopedData envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
        ASN1Set aSN1Set = envelopedData.getRecipientInfos();
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        int n = 0;
        while (n != aSN1Set.size()) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance((Object)aSN1Set.getObjectAt(n));
            if (recipientInfo.getInfo() instanceof KeyTransRecipientInfo) {
                arrayList.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipientInfo.getInfo(), envelopedData.getEncryptedContentInfo()));
            } else if (recipientInfo.getInfo() instanceof KEKRecipientInfo) {
                arrayList.add(new KEKRecipientInformation((KEKRecipientInfo)recipientInfo.getInfo(), envelopedData.getEncryptedContentInfo()));
            }
            ++n;
        }
        this.recipientInfoStore = new RecipientInformationStore(arrayList);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
        aSN1OutputStream.writeObject((Object)this.contentInfo);
        return byteArrayOutputStream.toByteArray();
    }
}

