/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;

public class SMIMETestUtil {
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyPairGenerator dsaKpg;
    public static KeyGenerator desede128kg;
    public static KeyGenerator desede192kg;
    public static KeyGenerator rc240kg;
    public static BigInteger serialNumber;
    public static final boolean DEBUG = true;

    public static KeyPair makeKeyPair() {
        return kpg.generateKeyPair();
    }

    public static KeyPair makeDSAKeyPair() {
        return dsaKpg.generateKeyPair();
    }

    public static SecretKey makeDesede128Key() {
        return desede128kg.generateKey();
    }

    public static SecretKey makeDesede192Key() {
        return desede192kg.generateKey();
    }

    public static SecretKey makeRC240Key() {
        return rc240kg.generateKey();
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        X509Name x509Name = new X509Name(string);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.reset();
        x509V3CertificateGenerator.setSerialNumber(SMIMETestUtil.allocateSerialNumber());
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string2));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        if (keyPair2.getPrivate() instanceof RSAPrivateKey) {
            x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        } else {
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1WithDSA");
        }
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)SMIMETestUtil.createSubjectKeyId(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)SMIMETestUtil.createAuthorityKeyId(publicKey2));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(false));
        X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(privateKey);
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(publicKey2);
        return x509Certificate;
    }

    public static MimeBodyPart makeMimeBodyPart(String string) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string);
        return mimeBodyPart;
    }

    public static MimeBodyPart makeMimeBodyPart(MimeMultipart mimeMultipart) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return mimeBodyPart;
    }

    public static MimeMultipart makeMimeMultipart(String string, String string2) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)SMIMETestUtil.makeMimeBodyPart(string));
        mimeMultipart.addBodyPart((BodyPart)SMIMETestUtil.makeMimeBodyPart(string2));
        return mimeMultipart;
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)byteArrayInputStream).readObject());
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey, X509Name x509Name, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)byteArrayInputStream).readObject());
        GeneralName generalName = new GeneralName(x509Name);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames((ASN1Sequence)new DERSequence((DEREncodable)generalName)), BigInteger.valueOf(n));
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)new DERInputStream((InputStream)byteArrayInputStream).readObject());
        return new SubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger bigInteger = serialNumber;
        serialNumber = serialNumber.add(new BigInteger("1"));
        return bigInteger;
    }

    public static void log(Exception exception) {
        exception.printStackTrace();
    }

    public static void log(String string) {
        System.out.println(string);
    }

    static {
        try {
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(1024, rand);
            dsaKpg = KeyPairGenerator.getInstance("DSA", "BC");
            dsaKpg.initialize(1024, rand);
            desede128kg = KeyGenerator.getInstance("DESEDE", "BC");
            desede128kg = KeyGenerator.getInstance("DESEDE", "BC");
            desede128kg.init(112, rand);
            desede192kg = KeyGenerator.getInstance("DESEDE", "BC");
            desede192kg.init(168, rand);
            rc240kg = KeyGenerator.getInstance("RC2", "BC");
            rc240kg.init(40, rand);
            serialNumber = new BigInteger("1");
        }
        catch (Exception exception) {
            SMIMETestUtil.log(exception);
        }
    }
}

