/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERBitString
extends DERObject {
    protected byte[] data;
    protected int padBits;

    protected DERBitString(byte by, int n) {
        this.data = new byte[1];
        this.data[0] = by;
        this.padBits = n;
    }

    public DERBitString(DEREncodable dEREncodable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(dEREncodable);
            dEROutputStream.close();
            this.data = byteArrayOutputStream.toByteArray();
            this.padBits = 0;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(byte[] byArray, int n) {
        this.data = byArray;
        this.padBits = n;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        byte[] byArray = new byte[this.getBytes().length + 1];
        byArray[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, byArray, 1, byArray.length - 1);
        dEROutputStream.writeEncoded(3, byArray);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERBitString)) {
            return false;
        }
        DERBitString dERBitString = (DERBitString)object;
        if (this.data.length != dERBitString.data.length) {
            return false;
        }
        int n = 0;
        while (n != this.data.length) {
            if (this.data[n] != dERBitString.data[n]) {
                return false;
            }
            ++n;
        }
        return this.padBits == dERBitString.padBits;
    }

    public byte[] getBytes() {
        return this.data;
    }

    protected static byte[] getBytes(int n) {
        if (n > 255) {
            byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
            return byArray;
        }
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        return byArray;
    }

    public static DERBitString getInstance(Object object) {
        if (object == null || object instanceof DERBitString) {
            return (DERBitString)object;
        }
        if (object instanceof ASN1OctetString) {
            byte[] byArray = ((ASN1OctetString)object).getOctets();
            byte by = byArray[0];
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return new DERBitString(byArray2, (int)by);
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBitString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERBitString.getInstance(aSN1TaggedObject.getObject());
    }

    public int getPadBits() {
        return this.padBits;
    }

    protected static int getPadBits(int n) {
        if (n == 0) {
            return 7;
        }
        int n2 = n > 255 ? n >> 8 & 0xFF : n & 0xFF;
        int n3 = 1;
        while (((n2 <<= 1) & 0xFF) != 0) {
            ++n3;
        }
        return 8 - n3;
    }
}

