/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class RC2WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private KeyParameter param;
    private ParametersWithIV paramPlusIV;
    private byte[] iv;
    private boolean forWrapping;
    private static final byte[] IV2 = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    Digest sha1 = new SHA1Digest();
    byte[] digest = new byte[20];

    private byte[] calculateCMSKeyChecksum(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        this.sha1.update(byArray, 0, byArray.length);
        this.sha1.doFinal(this.digest, 0);
        System.arraycopy(this.digest, 0, byArray2, 0, 8);
        return byArray2;
    }

    private boolean checkCMSKeyChecksum(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.calculateCMSKeyChecksum(byArray);
        if (byArray2.length != byArray3.length) {
            return false;
        }
        int n = 0;
        while (n != byArray2.length) {
            if (byArray2[n] != byArray3[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getAlgorithmName() {
        return "RC2";
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        this.engine = new CBCBlockCipher(new RC2Engine());
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
            if (this.forWrapping) {
                this.iv = new byte[8];
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextBytes(this.iv);
                this.paramPlusIV = new ParametersWithIV(this.param, this.iv);
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.paramPlusIV = (ParametersWithIV)cipherParameters;
            this.iv = this.paramPlusIV.getIV();
            this.param = (KeyParameter)this.paramPlusIV.getParameters();
            if (this.forWrapping) {
                if (this.iv == null || this.iv.length != 8) {
                    throw new IllegalArgumentException("IV is not 8 octets");
                }
            } else {
                throw new IllegalArgumentException("You should not supply an IV for unwrapping");
            }
        }
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("Not set for unwrapping");
        }
        if (byArray == null) {
            throw new InvalidCipherTextException("Null pointer as ciphertext");
        }
        if (n2 % this.engine.getBlockSize() != 0) {
            throw new InvalidCipherTextException("Ciphertext not multiple of " + this.engine.getBlockSize());
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.param, IV2);
        this.engine.init(false, parametersWithIV);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = 0;
        while (n3 < byArray2.length / this.engine.getBlockSize()) {
            int n4 = n3 * this.engine.getBlockSize();
            this.engine.processBlock(byArray2, n4, byArray2, n4);
            ++n3;
        }
        byte[] byArray3 = new byte[byArray2.length];
        int n5 = 0;
        while (n5 < byArray2.length) {
            byArray3[n5] = byArray2[byArray2.length - (n5 + 1)];
            ++n5;
        }
        this.iv = new byte[8];
        byte[] byArray4 = new byte[byArray3.length - 8];
        System.arraycopy(byArray3, 0, this.iv, 0, 8);
        System.arraycopy(byArray3, 8, byArray4, 0, byArray3.length - 8);
        this.paramPlusIV = new ParametersWithIV(this.param, this.iv);
        this.engine.init(false, this.paramPlusIV);
        byte[] byArray5 = new byte[byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        int n6 = 0;
        while (n6 < byArray5.length / this.engine.getBlockSize()) {
            int n7 = n6 * this.engine.getBlockSize();
            this.engine.processBlock(byArray5, n7, byArray5, n7);
            ++n6;
        }
        byte[] byArray6 = new byte[byArray5.length - 8];
        byte[] byArray7 = new byte[8];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray5.length - 8);
        System.arraycopy(byArray5, byArray5.length - 8, byArray7, 0, 8);
        if (!this.checkCMSKeyChecksum(byArray6, byArray7)) {
            throw new InvalidCipherTextException("Checksum inside ciphertext is corrupted");
        }
        if (byArray6.length - ((byArray6[0] & 0xFF) + 1) > 7) {
            throw new InvalidCipherTextException("too many pad bytes (" + (byArray6.length - ((byArray6[0] & 0xFF) + 1)) + ")");
        }
        byte[] byArray8 = new byte[byArray6[0]];
        System.arraycopy(byArray6, 1, byArray8, 0, byArray8.length);
        return byArray8;
    }

    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("Not initialized for wrapping");
        }
        int n3 = n2 + 1;
        if (n3 % 8 != 0) {
            n3 += 8 - n3 % 8;
        }
        byte[] byArray2 = new byte[n3];
        byArray2[0] = (byte)n2;
        System.arraycopy(byArray, n, byArray2, 1, n2);
        byte[] byArray3 = this.calculateCMSKeyChecksum(byArray2);
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        byte[] byArray5 = new byte[byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        int n4 = byArray4.length / this.engine.getBlockSize();
        int n5 = byArray4.length % this.engine.getBlockSize();
        if (n5 != 0) {
            throw new IllegalStateException("Not multiple of block length");
        }
        this.engine.init(true, this.paramPlusIV);
        int n6 = 0;
        while (n6 < n4) {
            int n7 = n6 * this.engine.getBlockSize();
            this.engine.processBlock(byArray5, n7, byArray5, n7);
            ++n6;
        }
        byte[] byArray6 = new byte[this.iv.length + byArray5.length];
        System.arraycopy(this.iv, 0, byArray6, 0, this.iv.length);
        System.arraycopy(byArray5, 0, byArray6, this.iv.length, byArray5.length);
        byte[] byArray7 = new byte[byArray6.length];
        int n8 = 0;
        while (n8 < byArray6.length) {
            byArray7[n8] = byArray6[byArray6.length - (n8 + 1)];
            ++n8;
        }
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.param, IV2);
        this.engine.init(true, parametersWithIV);
        int n9 = 0;
        while (n9 < n4 + 1) {
            int n10 = n9 * this.engine.getBlockSize();
            this.engine.processBlock(byArray7, n10, byArray7, n10);
            ++n9;
        }
        return byArray7;
    }
}

